package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExperimentStatusBuilder extends ExperimentStatusFluentImpl<ExperimentStatusBuilder> implements VisitableBuilder<ExperimentStatus,ExperimentStatusBuilder>{
  public ExperimentStatusBuilder() {
    this(false);
  }
  public ExperimentStatusBuilder(Boolean validationEnabled) {
    this(new ExperimentStatus(), validationEnabled);
  }
  public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExperimentStatus(), validationEnabled);
  }
  public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent,ExperimentStatus instance) {
    this(fluent, instance, false);
  }
  public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent,ExperimentStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withContainerRecords(instance.getContainerRecords());
      fluent.withDesiredPhase(instance.getDesiredPhase());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExperimentStatusBuilder(ExperimentStatus instance) {
    this(instance,false);
  }
  public ExperimentStatusBuilder(ExperimentStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withContainerRecords(instance.getContainerRecords());
      this.withDesiredPhase(instance.getDesiredPhase());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExperimentStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ExperimentStatus build() {
    ExperimentStatus buildable = new ExperimentStatus(fluent.getContainerRecords(),fluent.getDesiredPhase());
    return buildable;
  }
  
}