package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodChaosListBuilder extends PodChaosListFluentImpl<PodChaosListBuilder> implements VisitableBuilder<PodChaosList,PodChaosListBuilder>{
  public PodChaosListBuilder() {
    this(false);
  }
  public PodChaosListBuilder(Boolean validationEnabled) {
    this(new PodChaosList(), validationEnabled);
  }
  public PodChaosListBuilder(PodChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodChaosListBuilder(PodChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodChaosList(), validationEnabled);
  }
  public PodChaosListBuilder(PodChaosListFluent<?> fluent,PodChaosList instance) {
    this(fluent, instance, false);
  }
  public PodChaosListBuilder(PodChaosListFluent<?> fluent,PodChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodChaosListBuilder(PodChaosList instance) {
    this(instance,false);
  }
  public PodChaosListBuilder(PodChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public PodChaosList build() {
    PodChaosList buildable = new PodChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}