package io.fabric8.chaosmesh.v1alpha1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Deprecated;
import java.util.function.Predicate;
import java.util.List;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PhysicalMachineChaosSpecFluentImpl<A extends PhysicalMachineChaosSpecFluent<A>> extends BaseFluent<A> implements PhysicalMachineChaosSpecFluent<A>{
  public PhysicalMachineChaosSpecFluentImpl() {
  }
  public PhysicalMachineChaosSpecFluentImpl(PhysicalMachineChaosSpec instance) {
    if (instance != null) {
      this.withAction(instance.getAction());
      this.withAddress(instance.getAddress());
      this.withClock(instance.getClock());
      this.withDiskFill(instance.getDiskFill());
      this.withDiskReadPayload(instance.getDiskReadPayload());
      this.withDiskWritePayload(instance.getDiskWritePayload());
      this.withDuration(instance.getDuration());
      this.withJvmException(instance.getJvmException());
      this.withJvmGc(instance.getJvmGc());
      this.withJvmLatency(instance.getJvmLatency());
      this.withJvmReturn(instance.getJvmReturn());
      this.withJvmRuleData(instance.getJvmRuleData());
      this.withJvmStress(instance.getJvmStress());
      this.withMode(instance.getMode());
      this.withNetworkBandwidth(instance.getNetworkBandwidth());
      this.withNetworkCorrupt(instance.getNetworkCorrupt());
      this.withNetworkDelay(instance.getNetworkDelay());
      this.withNetworkDns(instance.getNetworkDns());
      this.withNetworkDuplicate(instance.getNetworkDuplicate());
      this.withNetworkLoss(instance.getNetworkLoss());
      this.withNetworkPartition(instance.getNetworkPartition());
      this.withProcess(instance.getProcess());
      this.withSelector(instance.getSelector());
      this.withStressCpu(instance.getStressCpu());
      this.withStressMem(instance.getStressMem());
      this.withUid(instance.getUid());
      this.withValue(instance.getValue());
    }
  }
  private String action;
  private List<String> address = new ArrayList<String>();
  private ClockSpecBuilder clock;
  private DiskFillSpecBuilder diskFill;
  private DiskPayloadSpecBuilder diskReadPayload;
  private DiskPayloadSpecBuilder diskWritePayload;
  private String duration;
  private JVMExceptionSpecBuilder jvmException;
  private JVMGCSpecBuilder jvmGc;
  private JVMLatencySpecBuilder jvmLatency;
  private JVMReturnSpecBuilder jvmReturn;
  private JVMRuleDataSpecBuilder jvmRuleData;
  private JVMStressSpecBuilder jvmStress;
  private String mode;
  private NetworkBandwidthSpecBuilder networkBandwidth;
  private NetworkCorruptSpecBuilder networkCorrupt;
  private NetworkDelaySpecBuilder networkDelay;
  private NetworkDNSSpecBuilder networkDns;
  private NetworkDuplicateSpecBuilder networkDuplicate;
  private NetworkLossSpecBuilder networkLoss;
  private NetworkPartitionSpecBuilder networkPartition;
  private ProcessSpecBuilder process;
  private PhysicalMachineSelectorSpecBuilder selector;
  private StressCPUSpecBuilder stressCpu;
  private StressMemorySpecBuilder stressMem;
  private String uid;
  private String value;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public A addToAddress(int index,String item) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    this.address.add(index, item);
    return (A)this;
  }
  public A setToAddress(int index,String item) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    this.address.set(index, item); return (A)this;
  }
  public A addToAddress(java.lang.String... items) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    for (String item : items) {this.address.add(item);} return (A)this;
  }
  public A addAllToAddress(Collection<String> items) {
    if (this.address == null) {this.address = new ArrayList<String>();}
    for (String item : items) {this.address.add(item);} return (A)this;
  }
  public A removeFromAddress(java.lang.String... items) {
    for (String item : items) {if (this.address!= null){ this.address.remove(item);}} return (A)this;
  }
  public A removeAllFromAddress(Collection<String> items) {
    for (String item : items) {if (this.address!= null){ this.address.remove(item);}} return (A)this;
  }
  public List<String> getAddress() {
    return this.address;
  }
  public String getAddress(int index) {
    return this.address.get(index);
  }
  public String getFirstAddress() {
    return this.address.get(0);
  }
  public String getLastAddress() {
    return this.address.get(address.size() - 1);
  }
  public String getMatchingAddress(Predicate<String> predicate) {
    for (String item: address) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAddress(Predicate<String> predicate) {
    for (String item: address) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddress(List<String> address) {
    if (address != null) {this.address = new ArrayList(); for (String item : address){this.addToAddress(item);}} else { this.address = null;} return (A) this;
  }
  public A withAddress(java.lang.String... address) {
    if (this.address != null) {this.address.clear(); _visitables.remove("address"); }
    if (address != null) {for (String item :address){ this.addToAddress(item);}} return (A) this;
  }
  public Boolean hasAddress() {
    return address != null && !address.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildClock instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClockSpec getClock() {
    return this.clock!=null ?this.clock.build():null;
  }
  public ClockSpec buildClock() {
    return this.clock!=null ?this.clock.build():null;
  }
  public A withClock(ClockSpec clock) {
    _visitables.get("clock").remove(this.clock);
    if (clock!=null){ this.clock= new ClockSpecBuilder(clock); _visitables.get("clock").add(this.clock);} else { this.clock = null; _visitables.get("clock").remove(this.clock); } return (A) this;
  }
  public Boolean hasClock() {
    return this.clock != null;
  }
  public A withNewClock(String clockIdsSlice,Integer pid,String timeOffset) {
    return (A)withClock(new ClockSpec(clockIdsSlice, pid, timeOffset));
  }
  public PhysicalMachineChaosSpecFluentImpl.ClockNested<A> withNewClock() {
    return new PhysicalMachineChaosSpecFluentImpl.ClockNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.ClockNested<A> withNewClockLike(ClockSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.ClockNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.ClockNested<A> editClock() {
    return withNewClockLike(getClock());
  }
  public PhysicalMachineChaosSpecFluentImpl.ClockNested<A> editOrNewClock() {
    return withNewClockLike(getClock() != null ? getClock(): new ClockSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.ClockNested<A> editOrNewClockLike(ClockSpec item) {
    return withNewClockLike(getClock() != null ? getClock(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDiskFill instead.
   * @return The buildable object.
   */
  @Deprecated
  public DiskFillSpec getDiskFill() {
    return this.diskFill!=null ?this.diskFill.build():null;
  }
  public DiskFillSpec buildDiskFill() {
    return this.diskFill!=null ?this.diskFill.build():null;
  }
  public A withDiskFill(DiskFillSpec diskFill) {
    _visitables.get("diskFill").remove(this.diskFill);
    if (diskFill!=null){ this.diskFill= new DiskFillSpecBuilder(diskFill); _visitables.get("diskFill").add(this.diskFill);} else { this.diskFill = null; _visitables.get("diskFill").remove(this.diskFill); } return (A) this;
  }
  public Boolean hasDiskFill() {
    return this.diskFill != null;
  }
  public A withNewDiskFill(Boolean fillByFallocate,String path,String size) {
    return (A)withDiskFill(new DiskFillSpec(fillByFallocate, path, size));
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskFillNested<A> withNewDiskFill() {
    return new PhysicalMachineChaosSpecFluentImpl.DiskFillNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskFillNested<A> withNewDiskFillLike(DiskFillSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.DiskFillNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskFillNested<A> editDiskFill() {
    return withNewDiskFillLike(getDiskFill());
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskFillNested<A> editOrNewDiskFill() {
    return withNewDiskFillLike(getDiskFill() != null ? getDiskFill(): new DiskFillSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskFillNested<A> editOrNewDiskFillLike(DiskFillSpec item) {
    return withNewDiskFillLike(getDiskFill() != null ? getDiskFill(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDiskReadPayload instead.
   * @return The buildable object.
   */
  @Deprecated
  public DiskPayloadSpec getDiskReadPayload() {
    return this.diskReadPayload!=null ?this.diskReadPayload.build():null;
  }
  public DiskPayloadSpec buildDiskReadPayload() {
    return this.diskReadPayload!=null ?this.diskReadPayload.build():null;
  }
  public A withDiskReadPayload(DiskPayloadSpec diskReadPayload) {
    _visitables.get("diskReadPayload").remove(this.diskReadPayload);
    if (diskReadPayload!=null){ this.diskReadPayload= new DiskPayloadSpecBuilder(diskReadPayload); _visitables.get("diskReadPayload").add(this.diskReadPayload);} else { this.diskReadPayload = null; _visitables.get("diskReadPayload").remove(this.diskReadPayload); } return (A) this;
  }
  public Boolean hasDiskReadPayload() {
    return this.diskReadPayload != null;
  }
  public A withNewDiskReadPayload(String path,Integer payloadProcessNum,String size) {
    return (A)withDiskReadPayload(new DiskPayloadSpec(path, payloadProcessNum, size));
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskReadPayloadNested<A> withNewDiskReadPayload() {
    return new PhysicalMachineChaosSpecFluentImpl.DiskReadPayloadNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskReadPayloadNested<A> withNewDiskReadPayloadLike(DiskPayloadSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.DiskReadPayloadNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskReadPayloadNested<A> editDiskReadPayload() {
    return withNewDiskReadPayloadLike(getDiskReadPayload());
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskReadPayloadNested<A> editOrNewDiskReadPayload() {
    return withNewDiskReadPayloadLike(getDiskReadPayload() != null ? getDiskReadPayload(): new DiskPayloadSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskReadPayloadNested<A> editOrNewDiskReadPayloadLike(DiskPayloadSpec item) {
    return withNewDiskReadPayloadLike(getDiskReadPayload() != null ? getDiskReadPayload(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDiskWritePayload instead.
   * @return The buildable object.
   */
  @Deprecated
  public DiskPayloadSpec getDiskWritePayload() {
    return this.diskWritePayload!=null ?this.diskWritePayload.build():null;
  }
  public DiskPayloadSpec buildDiskWritePayload() {
    return this.diskWritePayload!=null ?this.diskWritePayload.build():null;
  }
  public A withDiskWritePayload(DiskPayloadSpec diskWritePayload) {
    _visitables.get("diskWritePayload").remove(this.diskWritePayload);
    if (diskWritePayload!=null){ this.diskWritePayload= new DiskPayloadSpecBuilder(diskWritePayload); _visitables.get("diskWritePayload").add(this.diskWritePayload);} else { this.diskWritePayload = null; _visitables.get("diskWritePayload").remove(this.diskWritePayload); } return (A) this;
  }
  public Boolean hasDiskWritePayload() {
    return this.diskWritePayload != null;
  }
  public A withNewDiskWritePayload(String path,Integer payloadProcessNum,String size) {
    return (A)withDiskWritePayload(new DiskPayloadSpec(path, payloadProcessNum, size));
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskWritePayloadNested<A> withNewDiskWritePayload() {
    return new PhysicalMachineChaosSpecFluentImpl.DiskWritePayloadNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskWritePayloadNested<A> withNewDiskWritePayloadLike(DiskPayloadSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.DiskWritePayloadNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskWritePayloadNested<A> editDiskWritePayload() {
    return withNewDiskWritePayloadLike(getDiskWritePayload());
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskWritePayloadNested<A> editOrNewDiskWritePayload() {
    return withNewDiskWritePayloadLike(getDiskWritePayload() != null ? getDiskWritePayload(): new DiskPayloadSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.DiskWritePayloadNested<A> editOrNewDiskWritePayloadLike(DiskPayloadSpec item) {
    return withNewDiskWritePayloadLike(getDiskWritePayload() != null ? getDiskWritePayload(): item);
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  
  /**
   * This method has been deprecated, please use method buildJvmException instead.
   * @return The buildable object.
   */
  @Deprecated
  public JVMExceptionSpec getJvmException() {
    return this.jvmException!=null ?this.jvmException.build():null;
  }
  public JVMExceptionSpec buildJvmException() {
    return this.jvmException!=null ?this.jvmException.build():null;
  }
  public A withJvmException(JVMExceptionSpec jvmException) {
    _visitables.get("jvmException").remove(this.jvmException);
    if (jvmException!=null){ this.jvmException= new JVMExceptionSpecBuilder(jvmException); _visitables.get("jvmException").add(this.jvmException);} else { this.jvmException = null; _visitables.get("jvmException").remove(this.jvmException); } return (A) this;
  }
  public Boolean hasJvmException() {
    return this.jvmException != null;
  }
  public A withNewJvmException(String className,String exception,String method,Integer pid,Integer port) {
    return (A)withJvmException(new JVMExceptionSpec(className, exception, method, pid, port));
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmExceptionNested<A> withNewJvmException() {
    return new PhysicalMachineChaosSpecFluentImpl.JvmExceptionNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmExceptionNested<A> withNewJvmExceptionLike(JVMExceptionSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.JvmExceptionNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmExceptionNested<A> editJvmException() {
    return withNewJvmExceptionLike(getJvmException());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmExceptionNested<A> editOrNewJvmException() {
    return withNewJvmExceptionLike(getJvmException() != null ? getJvmException(): new JVMExceptionSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmExceptionNested<A> editOrNewJvmExceptionLike(JVMExceptionSpec item) {
    return withNewJvmExceptionLike(getJvmException() != null ? getJvmException(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildJvmGc instead.
   * @return The buildable object.
   */
  @Deprecated
  public JVMGCSpec getJvmGc() {
    return this.jvmGc!=null ?this.jvmGc.build():null;
  }
  public JVMGCSpec buildJvmGc() {
    return this.jvmGc!=null ?this.jvmGc.build():null;
  }
  public A withJvmGc(JVMGCSpec jvmGc) {
    _visitables.get("jvmGc").remove(this.jvmGc);
    if (jvmGc!=null){ this.jvmGc= new JVMGCSpecBuilder(jvmGc); _visitables.get("jvmGc").add(this.jvmGc);} else { this.jvmGc = null; _visitables.get("jvmGc").remove(this.jvmGc); } return (A) this;
  }
  public Boolean hasJvmGc() {
    return this.jvmGc != null;
  }
  public A withNewJvmGc(Integer pid,Integer port) {
    return (A)withJvmGc(new JVMGCSpec(pid, port));
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmGcNested<A> withNewJvmGc() {
    return new PhysicalMachineChaosSpecFluentImpl.JvmGcNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmGcNested<A> withNewJvmGcLike(JVMGCSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.JvmGcNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmGcNested<A> editJvmGc() {
    return withNewJvmGcLike(getJvmGc());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmGcNested<A> editOrNewJvmGc() {
    return withNewJvmGcLike(getJvmGc() != null ? getJvmGc(): new JVMGCSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmGcNested<A> editOrNewJvmGcLike(JVMGCSpec item) {
    return withNewJvmGcLike(getJvmGc() != null ? getJvmGc(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildJvmLatency instead.
   * @return The buildable object.
   */
  @Deprecated
  public JVMLatencySpec getJvmLatency() {
    return this.jvmLatency!=null ?this.jvmLatency.build():null;
  }
  public JVMLatencySpec buildJvmLatency() {
    return this.jvmLatency!=null ?this.jvmLatency.build():null;
  }
  public A withJvmLatency(JVMLatencySpec jvmLatency) {
    _visitables.get("jvmLatency").remove(this.jvmLatency);
    if (jvmLatency!=null){ this.jvmLatency= new JVMLatencySpecBuilder(jvmLatency); _visitables.get("jvmLatency").add(this.jvmLatency);} else { this.jvmLatency = null; _visitables.get("jvmLatency").remove(this.jvmLatency); } return (A) this;
  }
  public Boolean hasJvmLatency() {
    return this.jvmLatency != null;
  }
  public A withNewJvmLatency(String className,Integer latency,String method,Integer pid,Integer port) {
    return (A)withJvmLatency(new JVMLatencySpec(className, latency, method, pid, port));
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmLatencyNested<A> withNewJvmLatency() {
    return new PhysicalMachineChaosSpecFluentImpl.JvmLatencyNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmLatencyNested<A> withNewJvmLatencyLike(JVMLatencySpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.JvmLatencyNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmLatencyNested<A> editJvmLatency() {
    return withNewJvmLatencyLike(getJvmLatency());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmLatencyNested<A> editOrNewJvmLatency() {
    return withNewJvmLatencyLike(getJvmLatency() != null ? getJvmLatency(): new JVMLatencySpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmLatencyNested<A> editOrNewJvmLatencyLike(JVMLatencySpec item) {
    return withNewJvmLatencyLike(getJvmLatency() != null ? getJvmLatency(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildJvmReturn instead.
   * @return The buildable object.
   */
  @Deprecated
  public JVMReturnSpec getJvmReturn() {
    return this.jvmReturn!=null ?this.jvmReturn.build():null;
  }
  public JVMReturnSpec buildJvmReturn() {
    return this.jvmReturn!=null ?this.jvmReturn.build():null;
  }
  public A withJvmReturn(JVMReturnSpec jvmReturn) {
    _visitables.get("jvmReturn").remove(this.jvmReturn);
    if (jvmReturn!=null){ this.jvmReturn= new JVMReturnSpecBuilder(jvmReturn); _visitables.get("jvmReturn").add(this.jvmReturn);} else { this.jvmReturn = null; _visitables.get("jvmReturn").remove(this.jvmReturn); } return (A) this;
  }
  public Boolean hasJvmReturn() {
    return this.jvmReturn != null;
  }
  public A withNewJvmReturn(String className,String method,Integer pid,Integer port,String value) {
    return (A)withJvmReturn(new JVMReturnSpec(className, method, pid, port, value));
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmReturnNested<A> withNewJvmReturn() {
    return new PhysicalMachineChaosSpecFluentImpl.JvmReturnNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmReturnNested<A> withNewJvmReturnLike(JVMReturnSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.JvmReturnNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmReturnNested<A> editJvmReturn() {
    return withNewJvmReturnLike(getJvmReturn());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmReturnNested<A> editOrNewJvmReturn() {
    return withNewJvmReturnLike(getJvmReturn() != null ? getJvmReturn(): new JVMReturnSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmReturnNested<A> editOrNewJvmReturnLike(JVMReturnSpec item) {
    return withNewJvmReturnLike(getJvmReturn() != null ? getJvmReturn(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildJvmRuleData instead.
   * @return The buildable object.
   */
  @Deprecated
  public JVMRuleDataSpec getJvmRuleData() {
    return this.jvmRuleData!=null ?this.jvmRuleData.build():null;
  }
  public JVMRuleDataSpec buildJvmRuleData() {
    return this.jvmRuleData!=null ?this.jvmRuleData.build():null;
  }
  public A withJvmRuleData(JVMRuleDataSpec jvmRuleData) {
    _visitables.get("jvmRuleData").remove(this.jvmRuleData);
    if (jvmRuleData!=null){ this.jvmRuleData= new JVMRuleDataSpecBuilder(jvmRuleData); _visitables.get("jvmRuleData").add(this.jvmRuleData);} else { this.jvmRuleData = null; _visitables.get("jvmRuleData").remove(this.jvmRuleData); } return (A) this;
  }
  public Boolean hasJvmRuleData() {
    return this.jvmRuleData != null;
  }
  public A withNewJvmRuleData(Integer pid,Integer port,String ruleData) {
    return (A)withJvmRuleData(new JVMRuleDataSpec(pid, port, ruleData));
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmRuleDataNested<A> withNewJvmRuleData() {
    return new PhysicalMachineChaosSpecFluentImpl.JvmRuleDataNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmRuleDataNested<A> withNewJvmRuleDataLike(JVMRuleDataSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.JvmRuleDataNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmRuleDataNested<A> editJvmRuleData() {
    return withNewJvmRuleDataLike(getJvmRuleData());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmRuleDataNested<A> editOrNewJvmRuleData() {
    return withNewJvmRuleDataLike(getJvmRuleData() != null ? getJvmRuleData(): new JVMRuleDataSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmRuleDataNested<A> editOrNewJvmRuleDataLike(JVMRuleDataSpec item) {
    return withNewJvmRuleDataLike(getJvmRuleData() != null ? getJvmRuleData(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildJvmStress instead.
   * @return The buildable object.
   */
  @Deprecated
  public JVMStressSpec getJvmStress() {
    return this.jvmStress!=null ?this.jvmStress.build():null;
  }
  public JVMStressSpec buildJvmStress() {
    return this.jvmStress!=null ?this.jvmStress.build():null;
  }
  public A withJvmStress(JVMStressSpec jvmStress) {
    _visitables.get("jvmStress").remove(this.jvmStress);
    if (jvmStress!=null){ this.jvmStress= new JVMStressSpecBuilder(jvmStress); _visitables.get("jvmStress").add(this.jvmStress);} else { this.jvmStress = null; _visitables.get("jvmStress").remove(this.jvmStress); } return (A) this;
  }
  public Boolean hasJvmStress() {
    return this.jvmStress != null;
  }
  public A withNewJvmStress(Integer cpuCount,String memType,Integer pid,Integer port) {
    return (A)withJvmStress(new JVMStressSpec(cpuCount, memType, pid, port));
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmStressNested<A> withNewJvmStress() {
    return new PhysicalMachineChaosSpecFluentImpl.JvmStressNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmStressNested<A> withNewJvmStressLike(JVMStressSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.JvmStressNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmStressNested<A> editJvmStress() {
    return withNewJvmStressLike(getJvmStress());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmStressNested<A> editOrNewJvmStress() {
    return withNewJvmStressLike(getJvmStress() != null ? getJvmStress(): new JVMStressSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.JvmStressNested<A> editOrNewJvmStressLike(JVMStressSpec item) {
    return withNewJvmStressLike(getJvmStress() != null ? getJvmStress(): item);
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNetworkBandwidth instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkBandwidthSpec getNetworkBandwidth() {
    return this.networkBandwidth!=null ?this.networkBandwidth.build():null;
  }
  public NetworkBandwidthSpec buildNetworkBandwidth() {
    return this.networkBandwidth!=null ?this.networkBandwidth.build():null;
  }
  public A withNetworkBandwidth(NetworkBandwidthSpec networkBandwidth) {
    _visitables.get("networkBandwidth").remove(this.networkBandwidth);
    if (networkBandwidth!=null){ this.networkBandwidth= new NetworkBandwidthSpecBuilder(networkBandwidth); _visitables.get("networkBandwidth").add(this.networkBandwidth);} else { this.networkBandwidth = null; _visitables.get("networkBandwidth").remove(this.networkBandwidth); } return (A) this;
  }
  public Boolean hasNetworkBandwidth() {
    return this.networkBandwidth != null;
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkBandwidthNested<A> withNewNetworkBandwidth() {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkBandwidthNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkBandwidthNested<A> withNewNetworkBandwidthLike(NetworkBandwidthSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkBandwidthNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkBandwidthNested<A> editNetworkBandwidth() {
    return withNewNetworkBandwidthLike(getNetworkBandwidth());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkBandwidthNested<A> editOrNewNetworkBandwidth() {
    return withNewNetworkBandwidthLike(getNetworkBandwidth() != null ? getNetworkBandwidth(): new NetworkBandwidthSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkBandwidthNested<A> editOrNewNetworkBandwidthLike(NetworkBandwidthSpec item) {
    return withNewNetworkBandwidthLike(getNetworkBandwidth() != null ? getNetworkBandwidth(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNetworkCorrupt instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkCorruptSpec getNetworkCorrupt() {
    return this.networkCorrupt!=null ?this.networkCorrupt.build():null;
  }
  public NetworkCorruptSpec buildNetworkCorrupt() {
    return this.networkCorrupt!=null ?this.networkCorrupt.build():null;
  }
  public A withNetworkCorrupt(NetworkCorruptSpec networkCorrupt) {
    _visitables.get("networkCorrupt").remove(this.networkCorrupt);
    if (networkCorrupt!=null){ this.networkCorrupt= new NetworkCorruptSpecBuilder(networkCorrupt); _visitables.get("networkCorrupt").add(this.networkCorrupt);} else { this.networkCorrupt = null; _visitables.get("networkCorrupt").remove(this.networkCorrupt); } return (A) this;
  }
  public Boolean hasNetworkCorrupt() {
    return this.networkCorrupt != null;
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkCorruptNested<A> withNewNetworkCorrupt() {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkCorruptNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkCorruptNested<A> withNewNetworkCorruptLike(NetworkCorruptSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkCorruptNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkCorruptNested<A> editNetworkCorrupt() {
    return withNewNetworkCorruptLike(getNetworkCorrupt());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkCorruptNested<A> editOrNewNetworkCorrupt() {
    return withNewNetworkCorruptLike(getNetworkCorrupt() != null ? getNetworkCorrupt(): new NetworkCorruptSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkCorruptNested<A> editOrNewNetworkCorruptLike(NetworkCorruptSpec item) {
    return withNewNetworkCorruptLike(getNetworkCorrupt() != null ? getNetworkCorrupt(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNetworkDelay instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkDelaySpec getNetworkDelay() {
    return this.networkDelay!=null ?this.networkDelay.build():null;
  }
  public NetworkDelaySpec buildNetworkDelay() {
    return this.networkDelay!=null ?this.networkDelay.build():null;
  }
  public A withNetworkDelay(NetworkDelaySpec networkDelay) {
    _visitables.get("networkDelay").remove(this.networkDelay);
    if (networkDelay!=null){ this.networkDelay= new NetworkDelaySpecBuilder(networkDelay); _visitables.get("networkDelay").add(this.networkDelay);} else { this.networkDelay = null; _visitables.get("networkDelay").remove(this.networkDelay); } return (A) this;
  }
  public Boolean hasNetworkDelay() {
    return this.networkDelay != null;
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDelayNested<A> withNewNetworkDelay() {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkDelayNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDelayNested<A> withNewNetworkDelayLike(NetworkDelaySpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkDelayNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDelayNested<A> editNetworkDelay() {
    return withNewNetworkDelayLike(getNetworkDelay());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDelayNested<A> editOrNewNetworkDelay() {
    return withNewNetworkDelayLike(getNetworkDelay() != null ? getNetworkDelay(): new NetworkDelaySpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDelayNested<A> editOrNewNetworkDelayLike(NetworkDelaySpec item) {
    return withNewNetworkDelayLike(getNetworkDelay() != null ? getNetworkDelay(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNetworkDns instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkDNSSpec getNetworkDns() {
    return this.networkDns!=null ?this.networkDns.build():null;
  }
  public NetworkDNSSpec buildNetworkDns() {
    return this.networkDns!=null ?this.networkDns.build():null;
  }
  public A withNetworkDns(NetworkDNSSpec networkDns) {
    _visitables.get("networkDns").remove(this.networkDns);
    if (networkDns!=null){ this.networkDns= new NetworkDNSSpecBuilder(networkDns); _visitables.get("networkDns").add(this.networkDns);} else { this.networkDns = null; _visitables.get("networkDns").remove(this.networkDns); } return (A) this;
  }
  public Boolean hasNetworkDns() {
    return this.networkDns != null;
  }
  public A withNewNetworkDns(String dnsDomainName,String dnsIp,String dnsServer) {
    return (A)withNetworkDns(new NetworkDNSSpec(dnsDomainName, dnsIp, dnsServer));
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDnsNested<A> withNewNetworkDns() {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkDnsNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDnsNested<A> withNewNetworkDnsLike(NetworkDNSSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkDnsNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDnsNested<A> editNetworkDns() {
    return withNewNetworkDnsLike(getNetworkDns());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDnsNested<A> editOrNewNetworkDns() {
    return withNewNetworkDnsLike(getNetworkDns() != null ? getNetworkDns(): new NetworkDNSSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDnsNested<A> editOrNewNetworkDnsLike(NetworkDNSSpec item) {
    return withNewNetworkDnsLike(getNetworkDns() != null ? getNetworkDns(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNetworkDuplicate instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkDuplicateSpec getNetworkDuplicate() {
    return this.networkDuplicate!=null ?this.networkDuplicate.build():null;
  }
  public NetworkDuplicateSpec buildNetworkDuplicate() {
    return this.networkDuplicate!=null ?this.networkDuplicate.build():null;
  }
  public A withNetworkDuplicate(NetworkDuplicateSpec networkDuplicate) {
    _visitables.get("networkDuplicate").remove(this.networkDuplicate);
    if (networkDuplicate!=null){ this.networkDuplicate= new NetworkDuplicateSpecBuilder(networkDuplicate); _visitables.get("networkDuplicate").add(this.networkDuplicate);} else { this.networkDuplicate = null; _visitables.get("networkDuplicate").remove(this.networkDuplicate); } return (A) this;
  }
  public Boolean hasNetworkDuplicate() {
    return this.networkDuplicate != null;
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDuplicateNested<A> withNewNetworkDuplicate() {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkDuplicateNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDuplicateNested<A> withNewNetworkDuplicateLike(NetworkDuplicateSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkDuplicateNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDuplicateNested<A> editNetworkDuplicate() {
    return withNewNetworkDuplicateLike(getNetworkDuplicate());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDuplicateNested<A> editOrNewNetworkDuplicate() {
    return withNewNetworkDuplicateLike(getNetworkDuplicate() != null ? getNetworkDuplicate(): new NetworkDuplicateSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkDuplicateNested<A> editOrNewNetworkDuplicateLike(NetworkDuplicateSpec item) {
    return withNewNetworkDuplicateLike(getNetworkDuplicate() != null ? getNetworkDuplicate(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNetworkLoss instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkLossSpec getNetworkLoss() {
    return this.networkLoss!=null ?this.networkLoss.build():null;
  }
  public NetworkLossSpec buildNetworkLoss() {
    return this.networkLoss!=null ?this.networkLoss.build():null;
  }
  public A withNetworkLoss(NetworkLossSpec networkLoss) {
    _visitables.get("networkLoss").remove(this.networkLoss);
    if (networkLoss!=null){ this.networkLoss= new NetworkLossSpecBuilder(networkLoss); _visitables.get("networkLoss").add(this.networkLoss);} else { this.networkLoss = null; _visitables.get("networkLoss").remove(this.networkLoss); } return (A) this;
  }
  public Boolean hasNetworkLoss() {
    return this.networkLoss != null;
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkLossNested<A> withNewNetworkLoss() {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkLossNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkLossNested<A> withNewNetworkLossLike(NetworkLossSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkLossNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkLossNested<A> editNetworkLoss() {
    return withNewNetworkLossLike(getNetworkLoss());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkLossNested<A> editOrNewNetworkLoss() {
    return withNewNetworkLossLike(getNetworkLoss() != null ? getNetworkLoss(): new NetworkLossSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkLossNested<A> editOrNewNetworkLossLike(NetworkLossSpec item) {
    return withNewNetworkLossLike(getNetworkLoss() != null ? getNetworkLoss(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNetworkPartition instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkPartitionSpec getNetworkPartition() {
    return this.networkPartition!=null ?this.networkPartition.build():null;
  }
  public NetworkPartitionSpec buildNetworkPartition() {
    return this.networkPartition!=null ?this.networkPartition.build():null;
  }
  public A withNetworkPartition(NetworkPartitionSpec networkPartition) {
    _visitables.get("networkPartition").remove(this.networkPartition);
    if (networkPartition!=null){ this.networkPartition= new NetworkPartitionSpecBuilder(networkPartition); _visitables.get("networkPartition").add(this.networkPartition);} else { this.networkPartition = null; _visitables.get("networkPartition").remove(this.networkPartition); } return (A) this;
  }
  public Boolean hasNetworkPartition() {
    return this.networkPartition != null;
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkPartitionNested<A> withNewNetworkPartition() {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkPartitionNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkPartitionNested<A> withNewNetworkPartitionLike(NetworkPartitionSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.NetworkPartitionNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkPartitionNested<A> editNetworkPartition() {
    return withNewNetworkPartitionLike(getNetworkPartition());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkPartitionNested<A> editOrNewNetworkPartition() {
    return withNewNetworkPartitionLike(getNetworkPartition() != null ? getNetworkPartition(): new NetworkPartitionSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.NetworkPartitionNested<A> editOrNewNetworkPartitionLike(NetworkPartitionSpec item) {
    return withNewNetworkPartitionLike(getNetworkPartition() != null ? getNetworkPartition(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildProcess instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProcessSpec getProcess() {
    return this.process!=null ?this.process.build():null;
  }
  public ProcessSpec buildProcess() {
    return this.process!=null ?this.process.build():null;
  }
  public A withProcess(ProcessSpec process) {
    _visitables.get("process").remove(this.process);
    if (process!=null){ this.process= new ProcessSpecBuilder(process); _visitables.get("process").add(this.process);} else { this.process = null; _visitables.get("process").remove(this.process); } return (A) this;
  }
  public Boolean hasProcess() {
    return this.process != null;
  }
  public A withNewProcess(String process,Integer signal) {
    return (A)withProcess(new ProcessSpec(process, signal));
  }
  public PhysicalMachineChaosSpecFluentImpl.ProcessNested<A> withNewProcess() {
    return new PhysicalMachineChaosSpecFluentImpl.ProcessNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.ProcessNested<A> withNewProcessLike(ProcessSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.ProcessNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.ProcessNested<A> editProcess() {
    return withNewProcessLike(getProcess());
  }
  public PhysicalMachineChaosSpecFluentImpl.ProcessNested<A> editOrNewProcess() {
    return withNewProcessLike(getProcess() != null ? getProcess(): new ProcessSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.ProcessNested<A> editOrNewProcessLike(ProcessSpec item) {
    return withNewProcessLike(getProcess() != null ? getProcess(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public PhysicalMachineSelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public PhysicalMachineSelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(PhysicalMachineSelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new PhysicalMachineSelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public PhysicalMachineChaosSpecFluentImpl.SelectorNested<A> withNewSelector() {
    return new PhysicalMachineChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.SelectorNested<A> withNewSelectorLike(PhysicalMachineSelectorSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public PhysicalMachineChaosSpecFluentImpl.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new PhysicalMachineSelectorSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.SelectorNested<A> editOrNewSelectorLike(PhysicalMachineSelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStressCpu instead.
   * @return The buildable object.
   */
  @Deprecated
  public StressCPUSpec getStressCpu() {
    return this.stressCpu!=null ?this.stressCpu.build():null;
  }
  public StressCPUSpec buildStressCpu() {
    return this.stressCpu!=null ?this.stressCpu.build():null;
  }
  public A withStressCpu(StressCPUSpec stressCpu) {
    _visitables.get("stressCpu").remove(this.stressCpu);
    if (stressCpu!=null){ this.stressCpu= new StressCPUSpecBuilder(stressCpu); _visitables.get("stressCpu").add(this.stressCpu);} else { this.stressCpu = null; _visitables.get("stressCpu").remove(this.stressCpu); } return (A) this;
  }
  public Boolean hasStressCpu() {
    return this.stressCpu != null;
  }
  public A withNewStressCpu(Integer load,String options,Integer workers) {
    return (A)withStressCpu(new StressCPUSpec(load, options, workers));
  }
  public PhysicalMachineChaosSpecFluentImpl.StressCpuNested<A> withNewStressCpu() {
    return new PhysicalMachineChaosSpecFluentImpl.StressCpuNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.StressCpuNested<A> withNewStressCpuLike(StressCPUSpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.StressCpuNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.StressCpuNested<A> editStressCpu() {
    return withNewStressCpuLike(getStressCpu());
  }
  public PhysicalMachineChaosSpecFluentImpl.StressCpuNested<A> editOrNewStressCpu() {
    return withNewStressCpuLike(getStressCpu() != null ? getStressCpu(): new StressCPUSpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.StressCpuNested<A> editOrNewStressCpuLike(StressCPUSpec item) {
    return withNewStressCpuLike(getStressCpu() != null ? getStressCpu(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStressMem instead.
   * @return The buildable object.
   */
  @Deprecated
  public StressMemorySpec getStressMem() {
    return this.stressMem!=null ?this.stressMem.build():null;
  }
  public StressMemorySpec buildStressMem() {
    return this.stressMem!=null ?this.stressMem.build():null;
  }
  public A withStressMem(StressMemorySpec stressMem) {
    _visitables.get("stressMem").remove(this.stressMem);
    if (stressMem!=null){ this.stressMem= new StressMemorySpecBuilder(stressMem); _visitables.get("stressMem").add(this.stressMem);} else { this.stressMem = null; _visitables.get("stressMem").remove(this.stressMem); } return (A) this;
  }
  public Boolean hasStressMem() {
    return this.stressMem != null;
  }
  public A withNewStressMem(String options,String size) {
    return (A)withStressMem(new StressMemorySpec(options, size));
  }
  public PhysicalMachineChaosSpecFluentImpl.StressMemNested<A> withNewStressMem() {
    return new PhysicalMachineChaosSpecFluentImpl.StressMemNestedImpl();
  }
  public PhysicalMachineChaosSpecFluentImpl.StressMemNested<A> withNewStressMemLike(StressMemorySpec item) {
    return new PhysicalMachineChaosSpecFluentImpl.StressMemNestedImpl(item);
  }
  public PhysicalMachineChaosSpecFluentImpl.StressMemNested<A> editStressMem() {
    return withNewStressMemLike(getStressMem());
  }
  public PhysicalMachineChaosSpecFluentImpl.StressMemNested<A> editOrNewStressMem() {
    return withNewStressMemLike(getStressMem() != null ? getStressMem(): new StressMemorySpecBuilder().build());
  }
  public PhysicalMachineChaosSpecFluentImpl.StressMemNested<A> editOrNewStressMemLike(StressMemorySpec item) {
    return withNewStressMemLike(getStressMem() != null ? getStressMem(): item);
  }
  public String getUid() {
    return this.uid;
  }
  public A withUid(String uid) {
    this.uid=uid; return (A) this;
  }
  public Boolean hasUid() {
    return this.uid != null;
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PhysicalMachineChaosSpecFluentImpl that = (PhysicalMachineChaosSpecFluentImpl) o;
    if (!java.util.Objects.equals(action, that.action)) return false;

    if (!java.util.Objects.equals(address, that.address)) return false;

    if (!java.util.Objects.equals(clock, that.clock)) return false;

    if (!java.util.Objects.equals(diskFill, that.diskFill)) return false;

    if (!java.util.Objects.equals(diskReadPayload, that.diskReadPayload)) return false;

    if (!java.util.Objects.equals(diskWritePayload, that.diskWritePayload)) return false;

    if (!java.util.Objects.equals(duration, that.duration)) return false;

    if (!java.util.Objects.equals(jvmException, that.jvmException)) return false;

    if (!java.util.Objects.equals(jvmGc, that.jvmGc)) return false;

    if (!java.util.Objects.equals(jvmLatency, that.jvmLatency)) return false;

    if (!java.util.Objects.equals(jvmReturn, that.jvmReturn)) return false;

    if (!java.util.Objects.equals(jvmRuleData, that.jvmRuleData)) return false;

    if (!java.util.Objects.equals(jvmStress, that.jvmStress)) return false;

    if (!java.util.Objects.equals(mode, that.mode)) return false;

    if (!java.util.Objects.equals(networkBandwidth, that.networkBandwidth)) return false;

    if (!java.util.Objects.equals(networkCorrupt, that.networkCorrupt)) return false;

    if (!java.util.Objects.equals(networkDelay, that.networkDelay)) return false;

    if (!java.util.Objects.equals(networkDns, that.networkDns)) return false;

    if (!java.util.Objects.equals(networkDuplicate, that.networkDuplicate)) return false;

    if (!java.util.Objects.equals(networkLoss, that.networkLoss)) return false;

    if (!java.util.Objects.equals(networkPartition, that.networkPartition)) return false;

    if (!java.util.Objects.equals(process, that.process)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(stressCpu, that.stressCpu)) return false;

    if (!java.util.Objects.equals(stressMem, that.stressMem)) return false;

    if (!java.util.Objects.equals(uid, that.uid)) return false;

    if (!java.util.Objects.equals(value, that.value)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  address,  clock,  diskFill,  diskReadPayload,  diskWritePayload,  duration,  jvmException,  jvmGc,  jvmLatency,  jvmReturn,  jvmRuleData,  jvmStress,  mode,  networkBandwidth,  networkCorrupt,  networkDelay,  networkDns,  networkDuplicate,  networkLoss,  networkPartition,  process,  selector,  stressCpu,  stressMem,  uid,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (address != null && !address.isEmpty()) { sb.append("address:"); sb.append(address + ","); }
    if (clock != null) { sb.append("clock:"); sb.append(clock + ","); }
    if (diskFill != null) { sb.append("diskFill:"); sb.append(diskFill + ","); }
    if (diskReadPayload != null) { sb.append("diskReadPayload:"); sb.append(diskReadPayload + ","); }
    if (diskWritePayload != null) { sb.append("diskWritePayload:"); sb.append(diskWritePayload + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (jvmException != null) { sb.append("jvmException:"); sb.append(jvmException + ","); }
    if (jvmGc != null) { sb.append("jvmGc:"); sb.append(jvmGc + ","); }
    if (jvmLatency != null) { sb.append("jvmLatency:"); sb.append(jvmLatency + ","); }
    if (jvmReturn != null) { sb.append("jvmReturn:"); sb.append(jvmReturn + ","); }
    if (jvmRuleData != null) { sb.append("jvmRuleData:"); sb.append(jvmRuleData + ","); }
    if (jvmStress != null) { sb.append("jvmStress:"); sb.append(jvmStress + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (networkBandwidth != null) { sb.append("networkBandwidth:"); sb.append(networkBandwidth + ","); }
    if (networkCorrupt != null) { sb.append("networkCorrupt:"); sb.append(networkCorrupt + ","); }
    if (networkDelay != null) { sb.append("networkDelay:"); sb.append(networkDelay + ","); }
    if (networkDns != null) { sb.append("networkDns:"); sb.append(networkDns + ","); }
    if (networkDuplicate != null) { sb.append("networkDuplicate:"); sb.append(networkDuplicate + ","); }
    if (networkLoss != null) { sb.append("networkLoss:"); sb.append(networkLoss + ","); }
    if (networkPartition != null) { sb.append("networkPartition:"); sb.append(networkPartition + ","); }
    if (process != null) { sb.append("process:"); sb.append(process + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (stressCpu != null) { sb.append("stressCpu:"); sb.append(stressCpu + ","); }
    if (stressMem != null) { sb.append("stressMem:"); sb.append(stressMem + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  class ClockNestedImpl<N> extends ClockSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.ClockNested<N>> implements PhysicalMachineChaosSpecFluentImpl.ClockNested<N>,Nested<N>{
    ClockNestedImpl(ClockSpec item) {
      this.builder = new ClockSpecBuilder(this, item);
    }
    ClockNestedImpl() {
      this.builder = new ClockSpecBuilder(this);
    }
    ClockSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withClock(builder.build());
    }
    public N endClock() {
      return and();
    }
    
  }
  class DiskFillNestedImpl<N> extends DiskFillSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.DiskFillNested<N>> implements PhysicalMachineChaosSpecFluentImpl.DiskFillNested<N>,Nested<N>{
    DiskFillNestedImpl(DiskFillSpec item) {
      this.builder = new DiskFillSpecBuilder(this, item);
    }
    DiskFillNestedImpl() {
      this.builder = new DiskFillSpecBuilder(this);
    }
    DiskFillSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withDiskFill(builder.build());
    }
    public N endDiskFill() {
      return and();
    }
    
  }
  class DiskReadPayloadNestedImpl<N> extends DiskPayloadSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.DiskReadPayloadNested<N>> implements PhysicalMachineChaosSpecFluentImpl.DiskReadPayloadNested<N>,Nested<N>{
    DiskReadPayloadNestedImpl(DiskPayloadSpec item) {
      this.builder = new DiskPayloadSpecBuilder(this, item);
    }
    DiskReadPayloadNestedImpl() {
      this.builder = new DiskPayloadSpecBuilder(this);
    }
    DiskPayloadSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withDiskReadPayload(builder.build());
    }
    public N endDiskReadPayload() {
      return and();
    }
    
  }
  class DiskWritePayloadNestedImpl<N> extends DiskPayloadSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.DiskWritePayloadNested<N>> implements PhysicalMachineChaosSpecFluentImpl.DiskWritePayloadNested<N>,Nested<N>{
    DiskWritePayloadNestedImpl(DiskPayloadSpec item) {
      this.builder = new DiskPayloadSpecBuilder(this, item);
    }
    DiskWritePayloadNestedImpl() {
      this.builder = new DiskPayloadSpecBuilder(this);
    }
    DiskPayloadSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withDiskWritePayload(builder.build());
    }
    public N endDiskWritePayload() {
      return and();
    }
    
  }
  class JvmExceptionNestedImpl<N> extends JVMExceptionSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.JvmExceptionNested<N>> implements PhysicalMachineChaosSpecFluentImpl.JvmExceptionNested<N>,Nested<N>{
    JvmExceptionNestedImpl(JVMExceptionSpec item) {
      this.builder = new JVMExceptionSpecBuilder(this, item);
    }
    JvmExceptionNestedImpl() {
      this.builder = new JVMExceptionSpecBuilder(this);
    }
    JVMExceptionSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withJvmException(builder.build());
    }
    public N endJvmException() {
      return and();
    }
    
  }
  class JvmGcNestedImpl<N> extends JVMGCSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.JvmGcNested<N>> implements PhysicalMachineChaosSpecFluentImpl.JvmGcNested<N>,Nested<N>{
    JvmGcNestedImpl(JVMGCSpec item) {
      this.builder = new JVMGCSpecBuilder(this, item);
    }
    JvmGcNestedImpl() {
      this.builder = new JVMGCSpecBuilder(this);
    }
    JVMGCSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withJvmGc(builder.build());
    }
    public N endJvmGc() {
      return and();
    }
    
  }
  class JvmLatencyNestedImpl<N> extends JVMLatencySpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.JvmLatencyNested<N>> implements PhysicalMachineChaosSpecFluentImpl.JvmLatencyNested<N>,Nested<N>{
    JvmLatencyNestedImpl(JVMLatencySpec item) {
      this.builder = new JVMLatencySpecBuilder(this, item);
    }
    JvmLatencyNestedImpl() {
      this.builder = new JVMLatencySpecBuilder(this);
    }
    JVMLatencySpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withJvmLatency(builder.build());
    }
    public N endJvmLatency() {
      return and();
    }
    
  }
  class JvmReturnNestedImpl<N> extends JVMReturnSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.JvmReturnNested<N>> implements PhysicalMachineChaosSpecFluentImpl.JvmReturnNested<N>,Nested<N>{
    JvmReturnNestedImpl(JVMReturnSpec item) {
      this.builder = new JVMReturnSpecBuilder(this, item);
    }
    JvmReturnNestedImpl() {
      this.builder = new JVMReturnSpecBuilder(this);
    }
    JVMReturnSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withJvmReturn(builder.build());
    }
    public N endJvmReturn() {
      return and();
    }
    
  }
  class JvmRuleDataNestedImpl<N> extends JVMRuleDataSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.JvmRuleDataNested<N>> implements PhysicalMachineChaosSpecFluentImpl.JvmRuleDataNested<N>,Nested<N>{
    JvmRuleDataNestedImpl(JVMRuleDataSpec item) {
      this.builder = new JVMRuleDataSpecBuilder(this, item);
    }
    JvmRuleDataNestedImpl() {
      this.builder = new JVMRuleDataSpecBuilder(this);
    }
    JVMRuleDataSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withJvmRuleData(builder.build());
    }
    public N endJvmRuleData() {
      return and();
    }
    
  }
  class JvmStressNestedImpl<N> extends JVMStressSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.JvmStressNested<N>> implements PhysicalMachineChaosSpecFluentImpl.JvmStressNested<N>,Nested<N>{
    JvmStressNestedImpl(JVMStressSpec item) {
      this.builder = new JVMStressSpecBuilder(this, item);
    }
    JvmStressNestedImpl() {
      this.builder = new JVMStressSpecBuilder(this);
    }
    JVMStressSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withJvmStress(builder.build());
    }
    public N endJvmStress() {
      return and();
    }
    
  }
  class NetworkBandwidthNestedImpl<N> extends NetworkBandwidthSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.NetworkBandwidthNested<N>> implements PhysicalMachineChaosSpecFluentImpl.NetworkBandwidthNested<N>,Nested<N>{
    NetworkBandwidthNestedImpl(NetworkBandwidthSpec item) {
      this.builder = new NetworkBandwidthSpecBuilder(this, item);
    }
    NetworkBandwidthNestedImpl() {
      this.builder = new NetworkBandwidthSpecBuilder(this);
    }
    NetworkBandwidthSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withNetworkBandwidth(builder.build());
    }
    public N endNetworkBandwidth() {
      return and();
    }
    
  }
  class NetworkCorruptNestedImpl<N> extends NetworkCorruptSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.NetworkCorruptNested<N>> implements PhysicalMachineChaosSpecFluentImpl.NetworkCorruptNested<N>,Nested<N>{
    NetworkCorruptNestedImpl(NetworkCorruptSpec item) {
      this.builder = new NetworkCorruptSpecBuilder(this, item);
    }
    NetworkCorruptNestedImpl() {
      this.builder = new NetworkCorruptSpecBuilder(this);
    }
    NetworkCorruptSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withNetworkCorrupt(builder.build());
    }
    public N endNetworkCorrupt() {
      return and();
    }
    
  }
  class NetworkDelayNestedImpl<N> extends NetworkDelaySpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.NetworkDelayNested<N>> implements PhysicalMachineChaosSpecFluentImpl.NetworkDelayNested<N>,Nested<N>{
    NetworkDelayNestedImpl(NetworkDelaySpec item) {
      this.builder = new NetworkDelaySpecBuilder(this, item);
    }
    NetworkDelayNestedImpl() {
      this.builder = new NetworkDelaySpecBuilder(this);
    }
    NetworkDelaySpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withNetworkDelay(builder.build());
    }
    public N endNetworkDelay() {
      return and();
    }
    
  }
  class NetworkDnsNestedImpl<N> extends NetworkDNSSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.NetworkDnsNested<N>> implements PhysicalMachineChaosSpecFluentImpl.NetworkDnsNested<N>,Nested<N>{
    NetworkDnsNestedImpl(NetworkDNSSpec item) {
      this.builder = new NetworkDNSSpecBuilder(this, item);
    }
    NetworkDnsNestedImpl() {
      this.builder = new NetworkDNSSpecBuilder(this);
    }
    NetworkDNSSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withNetworkDns(builder.build());
    }
    public N endNetworkDns() {
      return and();
    }
    
  }
  class NetworkDuplicateNestedImpl<N> extends NetworkDuplicateSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.NetworkDuplicateNested<N>> implements PhysicalMachineChaosSpecFluentImpl.NetworkDuplicateNested<N>,Nested<N>{
    NetworkDuplicateNestedImpl(NetworkDuplicateSpec item) {
      this.builder = new NetworkDuplicateSpecBuilder(this, item);
    }
    NetworkDuplicateNestedImpl() {
      this.builder = new NetworkDuplicateSpecBuilder(this);
    }
    NetworkDuplicateSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withNetworkDuplicate(builder.build());
    }
    public N endNetworkDuplicate() {
      return and();
    }
    
  }
  class NetworkLossNestedImpl<N> extends NetworkLossSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.NetworkLossNested<N>> implements PhysicalMachineChaosSpecFluentImpl.NetworkLossNested<N>,Nested<N>{
    NetworkLossNestedImpl(NetworkLossSpec item) {
      this.builder = new NetworkLossSpecBuilder(this, item);
    }
    NetworkLossNestedImpl() {
      this.builder = new NetworkLossSpecBuilder(this);
    }
    NetworkLossSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withNetworkLoss(builder.build());
    }
    public N endNetworkLoss() {
      return and();
    }
    
  }
  class NetworkPartitionNestedImpl<N> extends NetworkPartitionSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.NetworkPartitionNested<N>> implements PhysicalMachineChaosSpecFluentImpl.NetworkPartitionNested<N>,Nested<N>{
    NetworkPartitionNestedImpl(NetworkPartitionSpec item) {
      this.builder = new NetworkPartitionSpecBuilder(this, item);
    }
    NetworkPartitionNestedImpl() {
      this.builder = new NetworkPartitionSpecBuilder(this);
    }
    NetworkPartitionSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withNetworkPartition(builder.build());
    }
    public N endNetworkPartition() {
      return and();
    }
    
  }
  class ProcessNestedImpl<N> extends ProcessSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.ProcessNested<N>> implements PhysicalMachineChaosSpecFluentImpl.ProcessNested<N>,Nested<N>{
    ProcessNestedImpl(ProcessSpec item) {
      this.builder = new ProcessSpecBuilder(this, item);
    }
    ProcessNestedImpl() {
      this.builder = new ProcessSpecBuilder(this);
    }
    ProcessSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withProcess(builder.build());
    }
    public N endProcess() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends PhysicalMachineSelectorSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.SelectorNested<N>> implements PhysicalMachineChaosSpecFluentImpl.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(PhysicalMachineSelectorSpec item) {
      this.builder = new PhysicalMachineSelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new PhysicalMachineSelectorSpecBuilder(this);
    }
    PhysicalMachineSelectorSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class StressCpuNestedImpl<N> extends StressCPUSpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.StressCpuNested<N>> implements PhysicalMachineChaosSpecFluentImpl.StressCpuNested<N>,Nested<N>{
    StressCpuNestedImpl(StressCPUSpec item) {
      this.builder = new StressCPUSpecBuilder(this, item);
    }
    StressCpuNestedImpl() {
      this.builder = new StressCPUSpecBuilder(this);
    }
    StressCPUSpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withStressCpu(builder.build());
    }
    public N endStressCpu() {
      return and();
    }
    
  }
  class StressMemNestedImpl<N> extends StressMemorySpecFluentImpl<PhysicalMachineChaosSpecFluentImpl.StressMemNested<N>> implements PhysicalMachineChaosSpecFluentImpl.StressMemNested<N>,Nested<N>{
    StressMemNestedImpl(StressMemorySpec item) {
      this.builder = new StressMemorySpecBuilder(this, item);
    }
    StressMemNestedImpl() {
      this.builder = new StressMemorySpecBuilder(this);
    }
    StressMemorySpecBuilder builder;
    public N and() {
      return (N) PhysicalMachineChaosSpecFluentImpl.this.withStressMem(builder.build());
    }
    public N endStressMem() {
      return and();
    }
    
  }
  
}