package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkDuplicateSpecBuilder extends NetworkDuplicateSpecFluentImpl<NetworkDuplicateSpecBuilder> implements VisitableBuilder<NetworkDuplicateSpec,NetworkDuplicateSpecBuilder>{
  public NetworkDuplicateSpecBuilder() {
    this(false);
  }
  public NetworkDuplicateSpecBuilder(Boolean validationEnabled) {
    this(new NetworkDuplicateSpec(), validationEnabled);
  }
  public NetworkDuplicateSpecBuilder(NetworkDuplicateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkDuplicateSpecBuilder(NetworkDuplicateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkDuplicateSpec(), validationEnabled);
  }
  public NetworkDuplicateSpecBuilder(NetworkDuplicateSpecFluent<?> fluent,NetworkDuplicateSpec instance) {
    this(fluent, instance, false);
  }
  public NetworkDuplicateSpecBuilder(NetworkDuplicateSpecFluent<?> fluent,NetworkDuplicateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCorrelation(instance.getCorrelation());
      fluent.withDevice(instance.getDevice());
      fluent.withEgressPort(instance.getEgressPort());
      fluent.withHostname(instance.getHostname());
      fluent.withIpAddress(instance.getIpAddress());
      fluent.withIpProtocol(instance.getIpProtocol());
      fluent.withPercent(instance.getPercent());
      fluent.withSourcePort(instance.getSourcePort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkDuplicateSpecBuilder(NetworkDuplicateSpec instance) {
    this(instance,false);
  }
  public NetworkDuplicateSpecBuilder(NetworkDuplicateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCorrelation(instance.getCorrelation());
      this.withDevice(instance.getDevice());
      this.withEgressPort(instance.getEgressPort());
      this.withHostname(instance.getHostname());
      this.withIpAddress(instance.getIpAddress());
      this.withIpProtocol(instance.getIpProtocol());
      this.withPercent(instance.getPercent());
      this.withSourcePort(instance.getSourcePort());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkDuplicateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkDuplicateSpec build() {
    NetworkDuplicateSpec buildable = new NetworkDuplicateSpec(fluent.getCorrelation(),fluent.getDevice(),fluent.getEgressPort(),fluent.getHostname(),fluent.getIpAddress(),fluent.getIpProtocol(),fluent.getPercent(),fluent.getSourcePort());
    return buildable;
  }
  
}