package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IOChaosActionFluentImpl<A extends IOChaosActionFluent<A>> extends BaseFluent<A> implements IOChaosActionFluent<A>{
  public IOChaosActionFluentImpl() {
  }
  public IOChaosActionFluentImpl(IOChaosAction instance) {
    if (instance != null) {
      this.withAtime(instance.getAtime());
      this.withBlocks(instance.getBlocks());
      this.withCtime(instance.getCtime());
      this.withFaults(instance.getFaults());
      this.withGid(instance.getGid());
      this.withIno(instance.getIno());
      this.withKind(instance.getKind());
      this.withLatency(instance.getLatency());
      this.withMethods(instance.getMethods());
      this.withMistake(instance.getMistake());
      this.withMtime(instance.getMtime());
      this.withNlink(instance.getNlink());
      this.withPath(instance.getPath());
      this.withPercent(instance.getPercent());
      this.withPerm(instance.getPerm());
      this.withRdev(instance.getRdev());
      this.withSize(instance.getSize());
      this.withSource(instance.getSource());
      this.withType(instance.getType());
      this.withUid(instance.getUid());
    }
  }
  private TimespecBuilder atime;
  private Long blocks;
  private TimespecBuilder ctime;
  private ArrayList<IoFaultBuilder> faults = new ArrayList<IoFaultBuilder>();
  private Long gid;
  private Long ino;
  private String kind;
  private String latency;
  private List<String> methods = new ArrayList<String>();
  private MistakeSpecBuilder mistake;
  private TimespecBuilder mtime;
  private Long nlink;
  private String path;
  private Integer percent;
  private Integer perm;
  private Long rdev;
  private Long size;
  private String source;
  private String type;
  private Long uid;
  
  /**
   * This method has been deprecated, please use method buildAtime instead.
   * @return The buildable object.
   */
  @Deprecated
  public Timespec getAtime() {
    return this.atime!=null ?this.atime.build():null;
  }
  public Timespec buildAtime() {
    return this.atime!=null ?this.atime.build():null;
  }
  public A withAtime(Timespec atime) {
    _visitables.get("atime").remove(this.atime);
    if (atime!=null){ this.atime= new TimespecBuilder(atime); _visitables.get("atime").add(this.atime);} else { this.atime = null; _visitables.get("atime").remove(this.atime); } return (A) this;
  }
  public Boolean hasAtime() {
    return this.atime != null;
  }
  public A withNewAtime(Long nsec,Long sec) {
    return (A)withAtime(new Timespec(nsec, sec));
  }
  public IOChaosActionFluentImpl.AtimeNested<A> withNewAtime() {
    return new IOChaosActionFluentImpl.AtimeNestedImpl();
  }
  public IOChaosActionFluentImpl.AtimeNested<A> withNewAtimeLike(Timespec item) {
    return new IOChaosActionFluentImpl.AtimeNestedImpl(item);
  }
  public IOChaosActionFluentImpl.AtimeNested<A> editAtime() {
    return withNewAtimeLike(getAtime());
  }
  public IOChaosActionFluentImpl.AtimeNested<A> editOrNewAtime() {
    return withNewAtimeLike(getAtime() != null ? getAtime(): new TimespecBuilder().build());
  }
  public IOChaosActionFluentImpl.AtimeNested<A> editOrNewAtimeLike(Timespec item) {
    return withNewAtimeLike(getAtime() != null ? getAtime(): item);
  }
  public Long getBlocks() {
    return this.blocks;
  }
  public A withBlocks(Long blocks) {
    this.blocks=blocks; return (A) this;
  }
  public Boolean hasBlocks() {
    return this.blocks != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCtime instead.
   * @return The buildable object.
   */
  @Deprecated
  public Timespec getCtime() {
    return this.ctime!=null ?this.ctime.build():null;
  }
  public Timespec buildCtime() {
    return this.ctime!=null ?this.ctime.build():null;
  }
  public A withCtime(Timespec ctime) {
    _visitables.get("ctime").remove(this.ctime);
    if (ctime!=null){ this.ctime= new TimespecBuilder(ctime); _visitables.get("ctime").add(this.ctime);} else { this.ctime = null; _visitables.get("ctime").remove(this.ctime); } return (A) this;
  }
  public Boolean hasCtime() {
    return this.ctime != null;
  }
  public A withNewCtime(Long nsec,Long sec) {
    return (A)withCtime(new Timespec(nsec, sec));
  }
  public IOChaosActionFluentImpl.CtimeNested<A> withNewCtime() {
    return new IOChaosActionFluentImpl.CtimeNestedImpl();
  }
  public IOChaosActionFluentImpl.CtimeNested<A> withNewCtimeLike(Timespec item) {
    return new IOChaosActionFluentImpl.CtimeNestedImpl(item);
  }
  public IOChaosActionFluentImpl.CtimeNested<A> editCtime() {
    return withNewCtimeLike(getCtime());
  }
  public IOChaosActionFluentImpl.CtimeNested<A> editOrNewCtime() {
    return withNewCtimeLike(getCtime() != null ? getCtime(): new TimespecBuilder().build());
  }
  public IOChaosActionFluentImpl.CtimeNested<A> editOrNewCtimeLike(Timespec item) {
    return withNewCtimeLike(getCtime() != null ? getCtime(): item);
  }
  public A addToFaults(int index,IoFault item) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    IoFaultBuilder builder = new IoFaultBuilder(item);
    if (index < 0 || index >= faults.size()) { _visitables.get("faults").add(builder); faults.add(builder); } else { _visitables.get("faults").add(index, builder); faults.add(index, builder);}
    return (A)this;
  }
  public A setToFaults(int index,IoFault item) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    IoFaultBuilder builder = new IoFaultBuilder(item);
    if (index < 0 || index >= faults.size()) { _visitables.get("faults").add(builder); faults.add(builder); } else { _visitables.get("faults").set(index, builder); faults.set(index, builder);}
    return (A)this;
  }
  public A addToFaults(io.fabric8.chaosmesh.v1alpha1.IoFault... items) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").add(builder);this.faults.add(builder);} return (A)this;
  }
  public A addAllToFaults(Collection<IoFault> items) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").add(builder);this.faults.add(builder);} return (A)this;
  }
  public A removeFromFaults(io.fabric8.chaosmesh.v1alpha1.IoFault... items) {
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").remove(builder);if (this.faults != null) {this.faults.remove(builder);}} return (A)this;
  }
  public A removeAllFromFaults(Collection<IoFault> items) {
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").remove(builder);if (this.faults != null) {this.faults.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFaults(Predicate<IoFaultBuilder> predicate) {
    if (faults == null) return (A) this;
    final Iterator<IoFaultBuilder> each = faults.iterator();
    final List visitables = _visitables.get("faults");
    while (each.hasNext()) {
      IoFaultBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildFaults instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IoFault> getFaults() {
    return faults != null ? build(faults) : null;
  }
  public List<IoFault> buildFaults() {
    return faults != null ? build(faults) : null;
  }
  public IoFault buildFault(int index) {
    return this.faults.get(index).build();
  }
  public IoFault buildFirstFault() {
    return this.faults.get(0).build();
  }
  public IoFault buildLastFault() {
    return this.faults.get(faults.size() - 1).build();
  }
  public IoFault buildMatchingFault(Predicate<IoFaultBuilder> predicate) {
    for (IoFaultBuilder item: faults) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingFault(Predicate<IoFaultBuilder> predicate) {
    for (IoFaultBuilder item: faults) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFaults(List<IoFault> faults) {
    if (this.faults != null) { _visitables.get("faults").clear();}
    if (faults != null) {this.faults = new ArrayList(); for (IoFault item : faults){this.addToFaults(item);}} else { this.faults = null;} return (A) this;
  }
  public A withFaults(io.fabric8.chaosmesh.v1alpha1.IoFault... faults) {
    if (this.faults != null) {this.faults.clear(); _visitables.remove("faults"); }
    if (faults != null) {for (IoFault item :faults){ this.addToFaults(item);}} return (A) this;
  }
  public Boolean hasFaults() {
    return faults != null && !faults.isEmpty();
  }
  public A addNewFault(Integer errno,Integer weight) {
    return (A)addToFaults(new IoFault(errno, weight));
  }
  public IOChaosActionFluentImpl.FaultsNested<A> addNewFault() {
    return new IOChaosActionFluentImpl.FaultsNestedImpl();
  }
  public IOChaosActionFluentImpl.FaultsNested<A> addNewFaultLike(IoFault item) {
    return new IOChaosActionFluentImpl.FaultsNestedImpl(-1, item);
  }
  public IOChaosActionFluentImpl.FaultsNested<A> setNewFaultLike(int index,IoFault item) {
    return new IOChaosActionFluentImpl.FaultsNestedImpl(index, item);
  }
  public IOChaosActionFluentImpl.FaultsNested<A> editFault(int index) {
    if (faults.size() <= index) throw new RuntimeException("Can't edit faults. Index exceeds size.");
    return setNewFaultLike(index, buildFault(index));
  }
  public IOChaosActionFluentImpl.FaultsNested<A> editFirstFault() {
    if (faults.size() == 0) throw new RuntimeException("Can't edit first faults. The list is empty.");
    return setNewFaultLike(0, buildFault(0));
  }
  public IOChaosActionFluentImpl.FaultsNested<A> editLastFault() {
    int index = faults.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last faults. The list is empty.");
    return setNewFaultLike(index, buildFault(index));
  }
  public IOChaosActionFluentImpl.FaultsNested<A> editMatchingFault(Predicate<IoFaultBuilder> predicate) {
    int index = -1;
    for (int i=0;i<faults.size();i++) { 
    if (predicate.test(faults.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching faults. No match found.");
    return setNewFaultLike(index, buildFault(index));
  }
  public Long getGid() {
    return this.gid;
  }
  public A withGid(Long gid) {
    this.gid=gid; return (A) this;
  }
  public Boolean hasGid() {
    return this.gid != null;
  }
  public Long getIno() {
    return this.ino;
  }
  public A withIno(Long ino) {
    this.ino=ino; return (A) this;
  }
  public Boolean hasIno() {
    return this.ino != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getLatency() {
    return this.latency;
  }
  public A withLatency(String latency) {
    this.latency=latency; return (A) this;
  }
  public Boolean hasLatency() {
    return this.latency != null;
  }
  public A addToMethods(int index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.add(index, item);
    return (A)this;
  }
  public A setToMethods(int index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.set(index, item); return (A)this;
  }
  public A addToMethods(java.lang.String... items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  public A addAllToMethods(Collection<String> items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  public A removeFromMethods(java.lang.String... items) {
    for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
  }
  public A removeAllFromMethods(Collection<String> items) {
    for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
  }
  public List<String> getMethods() {
    return this.methods;
  }
  public String getMethod(int index) {
    return this.methods.get(index);
  }
  public String getFirstMethod() {
    return this.methods.get(0);
  }
  public String getLastMethod() {
    return this.methods.get(methods.size() - 1);
  }
  public String getMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMethods(List<String> methods) {
    if (methods != null) {this.methods = new ArrayList(); for (String item : methods){this.addToMethods(item);}} else { this.methods = null;} return (A) this;
  }
  public A withMethods(java.lang.String... methods) {
    if (this.methods != null) {this.methods.clear(); _visitables.remove("methods"); }
    if (methods != null) {for (String item :methods){ this.addToMethods(item);}} return (A) this;
  }
  public Boolean hasMethods() {
    return methods != null && !methods.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildMistake instead.
   * @return The buildable object.
   */
  @Deprecated
  public MistakeSpec getMistake() {
    return this.mistake!=null ?this.mistake.build():null;
  }
  public MistakeSpec buildMistake() {
    return this.mistake!=null ?this.mistake.build():null;
  }
  public A withMistake(MistakeSpec mistake) {
    _visitables.get("mistake").remove(this.mistake);
    if (mistake!=null){ this.mistake= new MistakeSpecBuilder(mistake); _visitables.get("mistake").add(this.mistake);} else { this.mistake = null; _visitables.get("mistake").remove(this.mistake); } return (A) this;
  }
  public Boolean hasMistake() {
    return this.mistake != null;
  }
  public A withNewMistake(String filling,Long maxLength,Long maxOccurrences) {
    return (A)withMistake(new MistakeSpec(filling, maxLength, maxOccurrences));
  }
  public IOChaosActionFluentImpl.MistakeNested<A> withNewMistake() {
    return new IOChaosActionFluentImpl.MistakeNestedImpl();
  }
  public IOChaosActionFluentImpl.MistakeNested<A> withNewMistakeLike(MistakeSpec item) {
    return new IOChaosActionFluentImpl.MistakeNestedImpl(item);
  }
  public IOChaosActionFluentImpl.MistakeNested<A> editMistake() {
    return withNewMistakeLike(getMistake());
  }
  public IOChaosActionFluentImpl.MistakeNested<A> editOrNewMistake() {
    return withNewMistakeLike(getMistake() != null ? getMistake(): new MistakeSpecBuilder().build());
  }
  public IOChaosActionFluentImpl.MistakeNested<A> editOrNewMistakeLike(MistakeSpec item) {
    return withNewMistakeLike(getMistake() != null ? getMistake(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMtime instead.
   * @return The buildable object.
   */
  @Deprecated
  public Timespec getMtime() {
    return this.mtime!=null ?this.mtime.build():null;
  }
  public Timespec buildMtime() {
    return this.mtime!=null ?this.mtime.build():null;
  }
  public A withMtime(Timespec mtime) {
    _visitables.get("mtime").remove(this.mtime);
    if (mtime!=null){ this.mtime= new TimespecBuilder(mtime); _visitables.get("mtime").add(this.mtime);} else { this.mtime = null; _visitables.get("mtime").remove(this.mtime); } return (A) this;
  }
  public Boolean hasMtime() {
    return this.mtime != null;
  }
  public A withNewMtime(Long nsec,Long sec) {
    return (A)withMtime(new Timespec(nsec, sec));
  }
  public IOChaosActionFluentImpl.MtimeNested<A> withNewMtime() {
    return new IOChaosActionFluentImpl.MtimeNestedImpl();
  }
  public IOChaosActionFluentImpl.MtimeNested<A> withNewMtimeLike(Timespec item) {
    return new IOChaosActionFluentImpl.MtimeNestedImpl(item);
  }
  public IOChaosActionFluentImpl.MtimeNested<A> editMtime() {
    return withNewMtimeLike(getMtime());
  }
  public IOChaosActionFluentImpl.MtimeNested<A> editOrNewMtime() {
    return withNewMtimeLike(getMtime() != null ? getMtime(): new TimespecBuilder().build());
  }
  public IOChaosActionFluentImpl.MtimeNested<A> editOrNewMtimeLike(Timespec item) {
    return withNewMtimeLike(getMtime() != null ? getMtime(): item);
  }
  public Long getNlink() {
    return this.nlink;
  }
  public A withNlink(Long nlink) {
    this.nlink=nlink; return (A) this;
  }
  public Boolean hasNlink() {
    return this.nlink != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public Integer getPercent() {
    return this.percent;
  }
  public A withPercent(Integer percent) {
    this.percent=percent; return (A) this;
  }
  public Boolean hasPercent() {
    return this.percent != null;
  }
  public Integer getPerm() {
    return this.perm;
  }
  public A withPerm(Integer perm) {
    this.perm=perm; return (A) this;
  }
  public Boolean hasPerm() {
    return this.perm != null;
  }
  public Long getRdev() {
    return this.rdev;
  }
  public A withRdev(Long rdev) {
    this.rdev=rdev; return (A) this;
  }
  public Boolean hasRdev() {
    return this.rdev != null;
  }
  public Long getSize() {
    return this.size;
  }
  public A withSize(Long size) {
    this.size=size; return (A) this;
  }
  public Boolean hasSize() {
    return this.size != null;
  }
  public String getSource() {
    return this.source;
  }
  public A withSource(String source) {
    this.source=source; return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public Long getUid() {
    return this.uid;
  }
  public A withUid(Long uid) {
    this.uid=uid; return (A) this;
  }
  public Boolean hasUid() {
    return this.uid != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IOChaosActionFluentImpl that = (IOChaosActionFluentImpl) o;
    if (!java.util.Objects.equals(atime, that.atime)) return false;

    if (!java.util.Objects.equals(blocks, that.blocks)) return false;

    if (!java.util.Objects.equals(ctime, that.ctime)) return false;

    if (!java.util.Objects.equals(faults, that.faults)) return false;

    if (!java.util.Objects.equals(gid, that.gid)) return false;

    if (!java.util.Objects.equals(ino, that.ino)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(latency, that.latency)) return false;

    if (!java.util.Objects.equals(methods, that.methods)) return false;

    if (!java.util.Objects.equals(mistake, that.mistake)) return false;

    if (!java.util.Objects.equals(mtime, that.mtime)) return false;

    if (!java.util.Objects.equals(nlink, that.nlink)) return false;

    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(percent, that.percent)) return false;

    if (!java.util.Objects.equals(perm, that.perm)) return false;

    if (!java.util.Objects.equals(rdev, that.rdev)) return false;

    if (!java.util.Objects.equals(size, that.size)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(uid, that.uid)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(atime,  blocks,  ctime,  faults,  gid,  ino,  kind,  latency,  methods,  mistake,  mtime,  nlink,  path,  percent,  perm,  rdev,  size,  source,  type,  uid,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (atime != null) { sb.append("atime:"); sb.append(atime + ","); }
    if (blocks != null) { sb.append("blocks:"); sb.append(blocks + ","); }
    if (ctime != null) { sb.append("ctime:"); sb.append(ctime + ","); }
    if (faults != null) { sb.append("faults:"); sb.append(faults + ","); }
    if (gid != null) { sb.append("gid:"); sb.append(gid + ","); }
    if (ino != null) { sb.append("ino:"); sb.append(ino + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (latency != null) { sb.append("latency:"); sb.append(latency + ","); }
    if (methods != null && !methods.isEmpty()) { sb.append("methods:"); sb.append(methods + ","); }
    if (mistake != null) { sb.append("mistake:"); sb.append(mistake + ","); }
    if (mtime != null) { sb.append("mtime:"); sb.append(mtime + ","); }
    if (nlink != null) { sb.append("nlink:"); sb.append(nlink + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (perm != null) { sb.append("perm:"); sb.append(perm + ","); }
    if (rdev != null) { sb.append("rdev:"); sb.append(rdev + ","); }
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid); }
    sb.append("}");
    return sb.toString();
  }
  class AtimeNestedImpl<N> extends TimespecFluentImpl<IOChaosActionFluentImpl.AtimeNested<N>> implements IOChaosActionFluentImpl.AtimeNested<N>,Nested<N>{
    AtimeNestedImpl(Timespec item) {
      this.builder = new TimespecBuilder(this, item);
    }
    AtimeNestedImpl() {
      this.builder = new TimespecBuilder(this);
    }
    TimespecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluentImpl.this.withAtime(builder.build());
    }
    public N endAtime() {
      return and();
    }
    
  }
  class CtimeNestedImpl<N> extends TimespecFluentImpl<IOChaosActionFluentImpl.CtimeNested<N>> implements IOChaosActionFluentImpl.CtimeNested<N>,Nested<N>{
    CtimeNestedImpl(Timespec item) {
      this.builder = new TimespecBuilder(this, item);
    }
    CtimeNestedImpl() {
      this.builder = new TimespecBuilder(this);
    }
    TimespecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluentImpl.this.withCtime(builder.build());
    }
    public N endCtime() {
      return and();
    }
    
  }
  class FaultsNestedImpl<N> extends IoFaultFluentImpl<IOChaosActionFluentImpl.FaultsNested<N>> implements IOChaosActionFluentImpl.FaultsNested<N>,Nested<N>{
    FaultsNestedImpl(int index,IoFault item) {
      this.index = index;
      this.builder = new IoFaultBuilder(this, item);
    }
    FaultsNestedImpl() {
      this.index = -1;
      this.builder = new IoFaultBuilder(this);
    }
    IoFaultBuilder builder;
    int index;
    public N and() {
      return (N) IOChaosActionFluentImpl.this.setToFaults(index,builder.build());
    }
    public N endFault() {
      return and();
    }
    
  }
  class MistakeNestedImpl<N> extends MistakeSpecFluentImpl<IOChaosActionFluentImpl.MistakeNested<N>> implements IOChaosActionFluentImpl.MistakeNested<N>,Nested<N>{
    MistakeNestedImpl(MistakeSpec item) {
      this.builder = new MistakeSpecBuilder(this, item);
    }
    MistakeNestedImpl() {
      this.builder = new MistakeSpecBuilder(this);
    }
    MistakeSpecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluentImpl.this.withMistake(builder.build());
    }
    public N endMistake() {
      return and();
    }
    
  }
  class MtimeNestedImpl<N> extends TimespecFluentImpl<IOChaosActionFluentImpl.MtimeNested<N>> implements IOChaosActionFluentImpl.MtimeNested<N>,Nested<N>{
    MtimeNestedImpl(Timespec item) {
      this.builder = new TimespecBuilder(this, item);
    }
    MtimeNestedImpl() {
      this.builder = new TimespecBuilder(this);
    }
    TimespecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluentImpl.this.withMtime(builder.build());
    }
    public N endMtime() {
      return and();
    }
    
  }
  
}