package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GCPChaosStatusFluentImpl<A extends GCPChaosStatusFluent<A>> extends BaseFluent<A> implements GCPChaosStatusFluent<A>{
  public GCPChaosStatusFluentImpl() {
  }
  public GCPChaosStatusFluentImpl(GCPChaosStatus instance) {
    if (instance != null) {
      this.withAttachedDiskStrings(instance.getAttachedDiskStrings());
      this.withConditions(instance.getConditions());
      this.withExperiment(instance.getExperiment());
    }
  }
  private List<String> attachedDiskStrings = new ArrayList<String>();
  private ArrayList<ChaosConditionBuilder> conditions = new ArrayList<ChaosConditionBuilder>();
  private ExperimentStatusBuilder experiment;
  public A addToAttachedDiskStrings(int index,String item) {
    if (this.attachedDiskStrings == null) {this.attachedDiskStrings = new ArrayList<String>();}
    this.attachedDiskStrings.add(index, item);
    return (A)this;
  }
  public A setToAttachedDiskStrings(int index,String item) {
    if (this.attachedDiskStrings == null) {this.attachedDiskStrings = new ArrayList<String>();}
    this.attachedDiskStrings.set(index, item); return (A)this;
  }
  public A addToAttachedDiskStrings(java.lang.String... items) {
    if (this.attachedDiskStrings == null) {this.attachedDiskStrings = new ArrayList<String>();}
    for (String item : items) {this.attachedDiskStrings.add(item);} return (A)this;
  }
  public A addAllToAttachedDiskStrings(Collection<String> items) {
    if (this.attachedDiskStrings == null) {this.attachedDiskStrings = new ArrayList<String>();}
    for (String item : items) {this.attachedDiskStrings.add(item);} return (A)this;
  }
  public A removeFromAttachedDiskStrings(java.lang.String... items) {
    for (String item : items) {if (this.attachedDiskStrings!= null){ this.attachedDiskStrings.remove(item);}} return (A)this;
  }
  public A removeAllFromAttachedDiskStrings(Collection<String> items) {
    for (String item : items) {if (this.attachedDiskStrings!= null){ this.attachedDiskStrings.remove(item);}} return (A)this;
  }
  public List<String> getAttachedDiskStrings() {
    return this.attachedDiskStrings;
  }
  public String getAttachedDiskString(int index) {
    return this.attachedDiskStrings.get(index);
  }
  public String getFirstAttachedDiskString() {
    return this.attachedDiskStrings.get(0);
  }
  public String getLastAttachedDiskString() {
    return this.attachedDiskStrings.get(attachedDiskStrings.size() - 1);
  }
  public String getMatchingAttachedDiskString(Predicate<String> predicate) {
    for (String item: attachedDiskStrings) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAttachedDiskString(Predicate<String> predicate) {
    for (String item: attachedDiskStrings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAttachedDiskStrings(List<String> attachedDiskStrings) {
    if (attachedDiskStrings != null) {this.attachedDiskStrings = new ArrayList(); for (String item : attachedDiskStrings){this.addToAttachedDiskStrings(item);}} else { this.attachedDiskStrings = null;} return (A) this;
  }
  public A withAttachedDiskStrings(java.lang.String... attachedDiskStrings) {
    if (this.attachedDiskStrings != null) {this.attachedDiskStrings.clear(); _visitables.remove("attachedDiskStrings"); }
    if (attachedDiskStrings != null) {for (String item :attachedDiskStrings){ this.addToAttachedDiskStrings(item);}} return (A) this;
  }
  public Boolean hasAttachedDiskStrings() {
    return attachedDiskStrings != null && !attachedDiskStrings.isEmpty();
  }
  public A addToConditions(int index,ChaosCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    ChaosConditionBuilder builder = new ChaosConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,ChaosCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    ChaosConditionBuilder builder = new ChaosConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.chaosmesh.v1alpha1.ChaosCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ChaosCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.chaosmesh.v1alpha1.ChaosCondition... items) {
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ChaosCondition> items) {
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ChaosConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ChaosConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ChaosConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ChaosCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ChaosCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ChaosCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public ChaosCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ChaosCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ChaosCondition buildMatchingCondition(Predicate<ChaosConditionBuilder> predicate) {
    for (ChaosConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ChaosConditionBuilder> predicate) {
    for (ChaosConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ChaosCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ChaosCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.chaosmesh.v1alpha1.ChaosCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ChaosCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String reason,String status,String type) {
    return (A)addToConditions(new ChaosCondition(reason, status, type));
  }
  public GCPChaosStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new GCPChaosStatusFluentImpl.ConditionsNestedImpl();
  }
  public GCPChaosStatusFluentImpl.ConditionsNested<A> addNewConditionLike(ChaosCondition item) {
    return new GCPChaosStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public GCPChaosStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,ChaosCondition item) {
    return new GCPChaosStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public GCPChaosStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public GCPChaosStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public GCPChaosStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public GCPChaosStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<ChaosConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildExperiment instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExperimentStatus getExperiment() {
    return this.experiment!=null ?this.experiment.build():null;
  }
  public ExperimentStatus buildExperiment() {
    return this.experiment!=null ?this.experiment.build():null;
  }
  public A withExperiment(ExperimentStatus experiment) {
    _visitables.get("experiment").remove(this.experiment);
    if (experiment!=null){ this.experiment= new ExperimentStatusBuilder(experiment); _visitables.get("experiment").add(this.experiment);} else { this.experiment = null; _visitables.get("experiment").remove(this.experiment); } return (A) this;
  }
  public Boolean hasExperiment() {
    return this.experiment != null;
  }
  public GCPChaosStatusFluentImpl.ExperimentNested<A> withNewExperiment() {
    return new GCPChaosStatusFluentImpl.ExperimentNestedImpl();
  }
  public GCPChaosStatusFluentImpl.ExperimentNested<A> withNewExperimentLike(ExperimentStatus item) {
    return new GCPChaosStatusFluentImpl.ExperimentNestedImpl(item);
  }
  public GCPChaosStatusFluentImpl.ExperimentNested<A> editExperiment() {
    return withNewExperimentLike(getExperiment());
  }
  public GCPChaosStatusFluentImpl.ExperimentNested<A> editOrNewExperiment() {
    return withNewExperimentLike(getExperiment() != null ? getExperiment(): new ExperimentStatusBuilder().build());
  }
  public GCPChaosStatusFluentImpl.ExperimentNested<A> editOrNewExperimentLike(ExperimentStatus item) {
    return withNewExperimentLike(getExperiment() != null ? getExperiment(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GCPChaosStatusFluentImpl that = (GCPChaosStatusFluentImpl) o;
    if (!java.util.Objects.equals(attachedDiskStrings, that.attachedDiskStrings)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(experiment, that.experiment)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(attachedDiskStrings,  conditions,  experiment,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attachedDiskStrings != null && !attachedDiskStrings.isEmpty()) { sb.append("attachedDiskStrings:"); sb.append(attachedDiskStrings + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (experiment != null) { sb.append("experiment:"); sb.append(experiment); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ChaosConditionFluentImpl<GCPChaosStatusFluentImpl.ConditionsNested<N>> implements GCPChaosStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,ChaosCondition item) {
      this.index = index;
      this.builder = new ChaosConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ChaosConditionBuilder(this);
    }
    ChaosConditionBuilder builder;
    int index;
    public N and() {
      return (N) GCPChaosStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ExperimentNestedImpl<N> extends ExperimentStatusFluentImpl<GCPChaosStatusFluentImpl.ExperimentNested<N>> implements GCPChaosStatusFluentImpl.ExperimentNested<N>,Nested<N>{
    ExperimentNestedImpl(ExperimentStatus item) {
      this.builder = new ExperimentStatusBuilder(this, item);
    }
    ExperimentNestedImpl() {
      this.builder = new ExperimentStatusBuilder(this);
    }
    ExperimentStatusBuilder builder;
    public N and() {
      return (N) GCPChaosStatusFluentImpl.this.withExperiment(builder.build());
    }
    public N endExperiment() {
      return and();
    }
    
  }
  
}