package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DNSChaosSpecFluentImpl<A extends DNSChaosSpecFluent<A>> extends BaseFluent<A> implements DNSChaosSpecFluent<A>{
  public DNSChaosSpecFluentImpl() {
  }
  public DNSChaosSpecFluentImpl(DNSChaosSpec instance) {
    if (instance != null) {
      this.withAction(instance.getAction());
      this.withContainerNames(instance.getContainerNames());
      this.withDuration(instance.getDuration());
      this.withMode(instance.getMode());
      this.withPatterns(instance.getPatterns());
      this.withSelector(instance.getSelector());
      this.withValue(instance.getValue());
    }
  }
  private String action;
  private List<String> containerNames = new ArrayList<String>();
  private String duration;
  private String mode;
  private List<String> patterns = new ArrayList<String>();
  private PodSelectorSpecBuilder selector;
  private String value;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public A addToContainerNames(int index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.add(index, item);
    return (A)this;
  }
  public A setToContainerNames(int index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.set(index, item); return (A)this;
  }
  public A addToContainerNames(java.lang.String... items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A addAllToContainerNames(Collection<String> items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A removeFromContainerNames(java.lang.String... items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public A removeAllFromContainerNames(Collection<String> items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public List<String> getContainerNames() {
    return this.containerNames;
  }
  public String getContainerName(int index) {
    return this.containerNames.get(index);
  }
  public String getFirstContainerName() {
    return this.containerNames.get(0);
  }
  public String getLastContainerName() {
    return this.containerNames.get(containerNames.size() - 1);
  }
  public String getMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerNames(List<String> containerNames) {
    if (containerNames != null) {this.containerNames = new ArrayList(); for (String item : containerNames){this.addToContainerNames(item);}} else { this.containerNames = null;} return (A) this;
  }
  public A withContainerNames(java.lang.String... containerNames) {
    if (this.containerNames != null) {this.containerNames.clear(); _visitables.remove("containerNames"); }
    if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
  }
  public Boolean hasContainerNames() {
    return containerNames != null && !containerNames.isEmpty();
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  public A addToPatterns(int index,String item) {
    if (this.patterns == null) {this.patterns = new ArrayList<String>();}
    this.patterns.add(index, item);
    return (A)this;
  }
  public A setToPatterns(int index,String item) {
    if (this.patterns == null) {this.patterns = new ArrayList<String>();}
    this.patterns.set(index, item); return (A)this;
  }
  public A addToPatterns(java.lang.String... items) {
    if (this.patterns == null) {this.patterns = new ArrayList<String>();}
    for (String item : items) {this.patterns.add(item);} return (A)this;
  }
  public A addAllToPatterns(Collection<String> items) {
    if (this.patterns == null) {this.patterns = new ArrayList<String>();}
    for (String item : items) {this.patterns.add(item);} return (A)this;
  }
  public A removeFromPatterns(java.lang.String... items) {
    for (String item : items) {if (this.patterns!= null){ this.patterns.remove(item);}} return (A)this;
  }
  public A removeAllFromPatterns(Collection<String> items) {
    for (String item : items) {if (this.patterns!= null){ this.patterns.remove(item);}} return (A)this;
  }
  public List<String> getPatterns() {
    return this.patterns;
  }
  public String getPattern(int index) {
    return this.patterns.get(index);
  }
  public String getFirstPattern() {
    return this.patterns.get(0);
  }
  public String getLastPattern() {
    return this.patterns.get(patterns.size() - 1);
  }
  public String getMatchingPattern(Predicate<String> predicate) {
    for (String item: patterns) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPattern(Predicate<String> predicate) {
    for (String item: patterns) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPatterns(List<String> patterns) {
    if (patterns != null) {this.patterns = new ArrayList(); for (String item : patterns){this.addToPatterns(item);}} else { this.patterns = null;} return (A) this;
  }
  public A withPatterns(java.lang.String... patterns) {
    if (this.patterns != null) {this.patterns.clear(); _visitables.remove("patterns"); }
    if (patterns != null) {for (String item :patterns){ this.addToPatterns(item);}} return (A) this;
  }
  public Boolean hasPatterns() {
    return patterns != null && !patterns.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public PodSelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(PodSelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new PodSelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public DNSChaosSpecFluentImpl.SelectorNested<A> withNewSelector() {
    return new DNSChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public DNSChaosSpecFluentImpl.SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
    return new DNSChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public DNSChaosSpecFluentImpl.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public DNSChaosSpecFluentImpl.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new PodSelectorSpecBuilder().build());
  }
  public DNSChaosSpecFluentImpl.SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DNSChaosSpecFluentImpl that = (DNSChaosSpecFluentImpl) o;
    if (!java.util.Objects.equals(action, that.action)) return false;

    if (!java.util.Objects.equals(containerNames, that.containerNames)) return false;

    if (!java.util.Objects.equals(duration, that.duration)) return false;

    if (!java.util.Objects.equals(mode, that.mode)) return false;

    if (!java.util.Objects.equals(patterns, that.patterns)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(value, that.value)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  containerNames,  duration,  mode,  patterns,  selector,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (containerNames != null && !containerNames.isEmpty()) { sb.append("containerNames:"); sb.append(containerNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (patterns != null && !patterns.isEmpty()) { sb.append("patterns:"); sb.append(patterns + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  class SelectorNestedImpl<N> extends PodSelectorSpecFluentImpl<DNSChaosSpecFluentImpl.SelectorNested<N>> implements DNSChaosSpecFluentImpl.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(PodSelectorSpec item) {
      this.builder = new PodSelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new PodSelectorSpecBuilder(this);
    }
    PodSelectorSpecBuilder builder;
    public N and() {
      return (N) DNSChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}