package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSChaosListBuilder extends DNSChaosListFluentImpl<DNSChaosListBuilder> implements VisitableBuilder<DNSChaosList,DNSChaosListBuilder>{
  public DNSChaosListBuilder() {
    this(false);
  }
  public DNSChaosListBuilder(Boolean validationEnabled) {
    this(new DNSChaosList(), validationEnabled);
  }
  public DNSChaosListBuilder(DNSChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSChaosListBuilder(DNSChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSChaosList(), validationEnabled);
  }
  public DNSChaosListBuilder(DNSChaosListFluent<?> fluent,DNSChaosList instance) {
    this(fluent, instance, false);
  }
  public DNSChaosListBuilder(DNSChaosListFluent<?> fluent,DNSChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSChaosListBuilder(DNSChaosList instance) {
    this(instance,false);
  }
  public DNSChaosListBuilder(DNSChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public DNSChaosList build() {
    DNSChaosList buildable = new DNSChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}