package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AWSChaosFluentImpl<A extends AWSChaosFluent<A>> extends BaseFluent<A> implements AWSChaosFluent<A>{
  public AWSChaosFluentImpl() {
  }
  public AWSChaosFluentImpl(AWSChaos instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private AWSChaosSpecBuilder spec;
  private AWSChaosStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public AWSChaosFluentImpl.MetadataNested<A> withNewMetadata() {
    return new AWSChaosFluentImpl.MetadataNestedImpl();
  }
  public AWSChaosFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new AWSChaosFluentImpl.MetadataNestedImpl(item);
  }
  public AWSChaosFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public AWSChaosFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public AWSChaosFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public AWSChaosSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public AWSChaosSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(AWSChaosSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new AWSChaosSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public AWSChaosFluentImpl.SpecNested<A> withNewSpec() {
    return new AWSChaosFluentImpl.SpecNestedImpl();
  }
  public AWSChaosFluentImpl.SpecNested<A> withNewSpecLike(AWSChaosSpec item) {
    return new AWSChaosFluentImpl.SpecNestedImpl(item);
  }
  public AWSChaosFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public AWSChaosFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new AWSChaosSpecBuilder().build());
  }
  public AWSChaosFluentImpl.SpecNested<A> editOrNewSpecLike(AWSChaosSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public AWSChaosStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public AWSChaosStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(AWSChaosStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new AWSChaosStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public AWSChaosFluentImpl.StatusNested<A> withNewStatus() {
    return new AWSChaosFluentImpl.StatusNestedImpl();
  }
  public AWSChaosFluentImpl.StatusNested<A> withNewStatusLike(AWSChaosStatus item) {
    return new AWSChaosFluentImpl.StatusNestedImpl(item);
  }
  public AWSChaosFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public AWSChaosFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new AWSChaosStatusBuilder().build());
  }
  public AWSChaosFluentImpl.StatusNested<A> editOrNewStatusLike(AWSChaosStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSChaosFluentImpl that = (AWSChaosFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<AWSChaosFluentImpl.MetadataNested<N>> implements AWSChaosFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) AWSChaosFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends AWSChaosSpecFluentImpl<AWSChaosFluentImpl.SpecNested<N>> implements AWSChaosFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(AWSChaosSpec item) {
      this.builder = new AWSChaosSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new AWSChaosSpecBuilder(this);
    }
    AWSChaosSpecBuilder builder;
    public N and() {
      return (N) AWSChaosFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends AWSChaosStatusFluentImpl<AWSChaosFluentImpl.StatusNested<N>> implements AWSChaosFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(AWSChaosStatus item) {
      this.builder = new AWSChaosStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new AWSChaosStatusBuilder(this);
    }
    AWSChaosStatusBuilder builder;
    public N and() {
      return (N) AWSChaosFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}