package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StressCPUSpecBuilder extends StressCPUSpecFluentImpl<StressCPUSpecBuilder> implements VisitableBuilder<StressCPUSpec,StressCPUSpecBuilder>{
  public StressCPUSpecBuilder() {
    this(false);
  }
  public StressCPUSpecBuilder(Boolean validationEnabled) {
    this(new StressCPUSpec(), validationEnabled);
  }
  public StressCPUSpecBuilder(StressCPUSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StressCPUSpecBuilder(StressCPUSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StressCPUSpec(), validationEnabled);
  }
  public StressCPUSpecBuilder(StressCPUSpecFluent<?> fluent,StressCPUSpec instance) {
    this(fluent, instance, false);
  }
  public StressCPUSpecBuilder(StressCPUSpecFluent<?> fluent,StressCPUSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLoad(instance.getLoad()); 
    fluent.withOptions(instance.getOptions()); 
    fluent.withWorkers(instance.getWorkers()); 
    this.validationEnabled = validationEnabled; 
  }
  public StressCPUSpecBuilder(StressCPUSpec instance) {
    this(instance,false);
  }
  public StressCPUSpecBuilder(StressCPUSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLoad(instance.getLoad()); 
    this.withOptions(instance.getOptions()); 
    this.withWorkers(instance.getWorkers()); 
    this.validationEnabled = validationEnabled; 
  }
  StressCPUSpecFluent<?> fluent;
  Boolean validationEnabled;
  public StressCPUSpec build() {
    StressCPUSpec buildable = new StressCPUSpec(fluent.getLoad(),fluent.getOptions(),fluent.getWorkers());
    return buildable;
  }
  
}