package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodHttpChaosStatusBuilder extends PodHttpChaosStatusFluentImpl<PodHttpChaosStatusBuilder> implements VisitableBuilder<PodHttpChaosStatus,PodHttpChaosStatusBuilder>{
  public PodHttpChaosStatusBuilder() {
    this(false);
  }
  public PodHttpChaosStatusBuilder(Boolean validationEnabled) {
    this(new PodHttpChaosStatus(), validationEnabled);
  }
  public PodHttpChaosStatusBuilder(PodHttpChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodHttpChaosStatusBuilder(PodHttpChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodHttpChaosStatus(), validationEnabled);
  }
  public PodHttpChaosStatusBuilder(PodHttpChaosStatusFluent<?> fluent,PodHttpChaosStatus instance) {
    this(fluent, instance, false);
  }
  public PodHttpChaosStatusBuilder(PodHttpChaosStatusFluent<?> fluent,PodHttpChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFailedMessage(instance.getFailedMessage()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withPid(instance.getPid()); 
    fluent.withStartTime(instance.getStartTime()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodHttpChaosStatusBuilder(PodHttpChaosStatus instance) {
    this(instance,false);
  }
  public PodHttpChaosStatusBuilder(PodHttpChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFailedMessage(instance.getFailedMessage()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withPid(instance.getPid()); 
    this.withStartTime(instance.getStartTime()); 
    this.validationEnabled = validationEnabled; 
  }
  PodHttpChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodHttpChaosStatus build() {
    PodHttpChaosStatus buildable = new PodHttpChaosStatus(fluent.getFailedMessage(),fluent.getObservedGeneration(),fluent.getPid(),fluent.getStartTime());
    return buildable;
  }
  
}