package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodChaosStatusBuilder extends PodChaosStatusFluentImpl<PodChaosStatusBuilder> implements VisitableBuilder<PodChaosStatus,PodChaosStatusBuilder>{
  public PodChaosStatusBuilder() {
    this(false);
  }
  public PodChaosStatusBuilder(Boolean validationEnabled) {
    this(new PodChaosStatus(), validationEnabled);
  }
  public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodChaosStatus(), validationEnabled);
  }
  public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent,PodChaosStatus instance) {
    this(fluent, instance, false);
  }
  public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent,PodChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withExperiment(instance.getExperiment()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodChaosStatusBuilder(PodChaosStatus instance) {
    this(instance,false);
  }
  public PodChaosStatusBuilder(PodChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withExperiment(instance.getExperiment()); 
    this.validationEnabled = validationEnabled; 
  }
  PodChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodChaosStatus build() {
    PodChaosStatus buildable = new PodChaosStatus(fluent.getConditions(),fluent.getExperiment());
    return buildable;
  }
  
}