package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkChaosStatusFluentImpl<A extends NetworkChaosStatusFluent<A>> extends BaseFluent<A> implements NetworkChaosStatusFluent<A>{
  public NetworkChaosStatusFluentImpl() {
  }
  public NetworkChaosStatusFluentImpl(NetworkChaosStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withExperiment(instance.getExperiment()); 
    this.withInstances(instance.getInstances()); 
  }
  private ArrayList<ChaosConditionBuilder> conditions = new ArrayList<ChaosConditionBuilder>();
  private ExperimentStatusBuilder experiment;
  private Map<String,Long> instances;
  public A addToConditions(Integer index,ChaosCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,ChaosCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    ChaosConditionBuilder builder = new ChaosConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.chaosmesh.v1alpha1.ChaosCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ChaosCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ChaosConditionBuilder>();}
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.chaosmesh.v1alpha1.ChaosCondition... items) {
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ChaosCondition> items) {
    for (ChaosCondition item : items) {ChaosConditionBuilder builder = new ChaosConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ChaosConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ChaosConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ChaosConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ChaosCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ChaosCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ChaosCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public ChaosCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ChaosCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ChaosCondition buildMatchingCondition(Predicate<ChaosConditionBuilder> predicate) {
    for (ChaosConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ChaosConditionBuilder> predicate) {
    for (ChaosConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ChaosCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (ChaosCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.chaosmesh.v1alpha1.ChaosCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (ChaosCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String reason,String status,String type) {
    return (A)addToConditions(new ChaosCondition(reason, status, type));
  }
  public NetworkChaosStatusFluent.ConditionsNested<A> addNewCondition() {
    return new NetworkChaosStatusFluentImpl.ConditionsNestedImpl();
  }
  public NetworkChaosStatusFluent.ConditionsNested<A> addNewConditionLike(ChaosCondition item) {
    return new NetworkChaosStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public NetworkChaosStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,ChaosCondition item) {
    return new NetworkChaosStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public NetworkChaosStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public NetworkChaosStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public NetworkChaosStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public NetworkChaosStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ChaosConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildExperiment instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExperimentStatus getExperiment() {
    return this.experiment!=null ?this.experiment.build():null;
  }
  public ExperimentStatus buildExperiment() {
    return this.experiment!=null ?this.experiment.build():null;
  }
  public A withExperiment(ExperimentStatus experiment) {
    _visitables.get("experiment").remove(this.experiment);
    if (experiment!=null){ this.experiment= new ExperimentStatusBuilder(experiment); _visitables.get("experiment").add(this.experiment);} else { this.experiment = null; _visitables.get("experiment").remove(this.experiment); } return (A) this;
  }
  public Boolean hasExperiment() {
    return this.experiment != null;
  }
  public NetworkChaosStatusFluent.ExperimentNested<A> withNewExperiment() {
    return new NetworkChaosStatusFluentImpl.ExperimentNestedImpl();
  }
  public NetworkChaosStatusFluent.ExperimentNested<A> withNewExperimentLike(ExperimentStatus item) {
    return new NetworkChaosStatusFluentImpl.ExperimentNestedImpl(item);
  }
  public NetworkChaosStatusFluent.ExperimentNested<A> editExperiment() {
    return withNewExperimentLike(getExperiment());
  }
  public NetworkChaosStatusFluent.ExperimentNested<A> editOrNewExperiment() {
    return withNewExperimentLike(getExperiment() != null ? getExperiment(): new ExperimentStatusBuilder().build());
  }
  public NetworkChaosStatusFluent.ExperimentNested<A> editOrNewExperimentLike(ExperimentStatus item) {
    return withNewExperimentLike(getExperiment() != null ? getExperiment(): item);
  }
  public A addToInstances(String key,Long value) {
    if(this.instances == null && key != null && value != null) { this.instances = new LinkedHashMap(); }
    if(key != null && value != null) {this.instances.put(key, value);} return (A)this;
  }
  public A addToInstances(Map<String,Long> map) {
    if(this.instances == null && map != null) { this.instances = new LinkedHashMap(); }
    if(map != null) { this.instances.putAll(map);} return (A)this;
  }
  public A removeFromInstances(String key) {
    if(this.instances == null) { return (A) this; }
    if(key != null && this.instances != null) {this.instances.remove(key);} return (A)this;
  }
  public A removeFromInstances(Map<String,Long> map) {
    if(this.instances == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.instances != null){this.instances.remove(key);}}} return (A)this;
  }
  public Map<String,Long> getInstances() {
    return this.instances;
  }
  public <K,V>A withInstances(Map<String,Long> instances) {
    if (instances == null) { this.instances =  null;} else {this.instances = new LinkedHashMap(instances);} return (A) this;
  }
  public Boolean hasInstances() {
    return this.instances != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkChaosStatusFluentImpl that = (NetworkChaosStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (experiment != null ? !experiment.equals(that.experiment) :that.experiment != null) return false;
    if (instances != null ? !instances.equals(that.instances) :that.instances != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  experiment,  instances,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (experiment != null) { sb.append("experiment:"); sb.append(experiment + ","); }
    if (instances != null && !instances.isEmpty()) { sb.append("instances:"); sb.append(instances); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ChaosConditionFluentImpl<NetworkChaosStatusFluent.ConditionsNested<N>> implements NetworkChaosStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,ChaosCondition item) {
      this.index = index;
      this.builder = new ChaosConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ChaosConditionBuilder(this);
    }
    ChaosConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) NetworkChaosStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ExperimentNestedImpl<N> extends ExperimentStatusFluentImpl<NetworkChaosStatusFluent.ExperimentNested<N>> implements NetworkChaosStatusFluent.ExperimentNested<N>,Nested<N>{
    ExperimentNestedImpl(ExperimentStatus item) {
      this.builder = new ExperimentStatusBuilder(this, item);
    }
    ExperimentNestedImpl() {
      this.builder = new ExperimentStatusBuilder(this);
    }
    ExperimentStatusBuilder builder;
    public N and() {
      return (N) NetworkChaosStatusFluentImpl.this.withExperiment(builder.build());
    }
    public N endExperiment() {
      return and();
    }
    
  }
  
}