package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IOChaosStatusBuilder extends IOChaosStatusFluentImpl<IOChaosStatusBuilder> implements VisitableBuilder<IOChaosStatus,IOChaosStatusBuilder>{
  public IOChaosStatusBuilder() {
    this(false);
  }
  public IOChaosStatusBuilder(Boolean validationEnabled) {
    this(new IOChaosStatus(), validationEnabled);
  }
  public IOChaosStatusBuilder(IOChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IOChaosStatusBuilder(IOChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IOChaosStatus(), validationEnabled);
  }
  public IOChaosStatusBuilder(IOChaosStatusFluent<?> fluent,IOChaosStatus instance) {
    this(fluent, instance, false);
  }
  public IOChaosStatusBuilder(IOChaosStatusFluent<?> fluent,IOChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withExperiment(instance.getExperiment()); 
    fluent.withInstances(instance.getInstances()); 
    this.validationEnabled = validationEnabled; 
  }
  public IOChaosStatusBuilder(IOChaosStatus instance) {
    this(instance,false);
  }
  public IOChaosStatusBuilder(IOChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withExperiment(instance.getExperiment()); 
    this.withInstances(instance.getInstances()); 
    this.validationEnabled = validationEnabled; 
  }
  IOChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IOChaosStatus build() {
    IOChaosStatus buildable = new IOChaosStatus(fluent.getConditions(),fluent.getExperiment(),fluent.getInstances());
    return buildable;
  }
  
}