package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IOChaosActionFluentImpl<A extends IOChaosActionFluent<A>> extends BaseFluent<A> implements IOChaosActionFluent<A>{
  public IOChaosActionFluentImpl() {
  }
  public IOChaosActionFluentImpl(IOChaosAction instance) {
    this.withAtime(instance.getAtime()); 
    this.withBlocks(instance.getBlocks()); 
    this.withCtime(instance.getCtime()); 
    this.withFaults(instance.getFaults()); 
    this.withGid(instance.getGid()); 
    this.withIno(instance.getIno()); 
    this.withKind(instance.getKind()); 
    this.withLatency(instance.getLatency()); 
    this.withMethods(instance.getMethods()); 
    this.withMistake(instance.getMistake()); 
    this.withMtime(instance.getMtime()); 
    this.withNlink(instance.getNlink()); 
    this.withPath(instance.getPath()); 
    this.withPercent(instance.getPercent()); 
    this.withPerm(instance.getPerm()); 
    this.withRdev(instance.getRdev()); 
    this.withSize(instance.getSize()); 
    this.withSource(instance.getSource()); 
    this.withType(instance.getType()); 
    this.withUid(instance.getUid()); 
  }
  private TimespecBuilder atime;
  private Long blocks;
  private TimespecBuilder ctime;
  private ArrayList<IoFaultBuilder> faults = new ArrayList<IoFaultBuilder>();
  private Long gid;
  private Long ino;
  private String kind;
  private String latency;
  private List<String> methods = new ArrayList<String>();
  private MistakeSpecBuilder mistake;
  private TimespecBuilder mtime;
  private Long nlink;
  private String path;
  private Integer percent;
  private Integer perm;
  private Long rdev;
  private Long size;
  private String source;
  private String type;
  private Long uid;
  
  /**
   * This method has been deprecated, please use method buildAtime instead.
   * @return The buildable object.
   */
  @Deprecated
  public Timespec getAtime() {
    return this.atime!=null ?this.atime.build():null;
  }
  public Timespec buildAtime() {
    return this.atime!=null ?this.atime.build():null;
  }
  public A withAtime(Timespec atime) {
    _visitables.get("atime").remove(this.atime);
    if (atime!=null){ this.atime= new TimespecBuilder(atime); _visitables.get("atime").add(this.atime);} else { this.atime = null; _visitables.get("atime").remove(this.atime); } return (A) this;
  }
  public Boolean hasAtime() {
    return this.atime != null;
  }
  public A withNewAtime(Long nsec,Long sec) {
    return (A)withAtime(new Timespec(nsec, sec));
  }
  public IOChaosActionFluent.AtimeNested<A> withNewAtime() {
    return new IOChaosActionFluentImpl.AtimeNestedImpl();
  }
  public IOChaosActionFluent.AtimeNested<A> withNewAtimeLike(Timespec item) {
    return new IOChaosActionFluentImpl.AtimeNestedImpl(item);
  }
  public IOChaosActionFluent.AtimeNested<A> editAtime() {
    return withNewAtimeLike(getAtime());
  }
  public IOChaosActionFluent.AtimeNested<A> editOrNewAtime() {
    return withNewAtimeLike(getAtime() != null ? getAtime(): new TimespecBuilder().build());
  }
  public IOChaosActionFluent.AtimeNested<A> editOrNewAtimeLike(Timespec item) {
    return withNewAtimeLike(getAtime() != null ? getAtime(): item);
  }
  public Long getBlocks() {
    return this.blocks;
  }
  public A withBlocks(Long blocks) {
    this.blocks=blocks; return (A) this;
  }
  public Boolean hasBlocks() {
    return this.blocks != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCtime instead.
   * @return The buildable object.
   */
  @Deprecated
  public Timespec getCtime() {
    return this.ctime!=null ?this.ctime.build():null;
  }
  public Timespec buildCtime() {
    return this.ctime!=null ?this.ctime.build():null;
  }
  public A withCtime(Timespec ctime) {
    _visitables.get("ctime").remove(this.ctime);
    if (ctime!=null){ this.ctime= new TimespecBuilder(ctime); _visitables.get("ctime").add(this.ctime);} else { this.ctime = null; _visitables.get("ctime").remove(this.ctime); } return (A) this;
  }
  public Boolean hasCtime() {
    return this.ctime != null;
  }
  public A withNewCtime(Long nsec,Long sec) {
    return (A)withCtime(new Timespec(nsec, sec));
  }
  public IOChaosActionFluent.CtimeNested<A> withNewCtime() {
    return new IOChaosActionFluentImpl.CtimeNestedImpl();
  }
  public IOChaosActionFluent.CtimeNested<A> withNewCtimeLike(Timespec item) {
    return new IOChaosActionFluentImpl.CtimeNestedImpl(item);
  }
  public IOChaosActionFluent.CtimeNested<A> editCtime() {
    return withNewCtimeLike(getCtime());
  }
  public IOChaosActionFluent.CtimeNested<A> editOrNewCtime() {
    return withNewCtimeLike(getCtime() != null ? getCtime(): new TimespecBuilder().build());
  }
  public IOChaosActionFluent.CtimeNested<A> editOrNewCtimeLike(Timespec item) {
    return withNewCtimeLike(getCtime() != null ? getCtime(): item);
  }
  public A addToFaults(Integer index,IoFault item) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").add(index >= 0 ? index : _visitables.get("faults").size(), builder);this.faults.add(index >= 0 ? index : faults.size(), builder); return (A)this;
  }
  public A setToFaults(Integer index,IoFault item) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    IoFaultBuilder builder = new IoFaultBuilder(item);
    if (index < 0 || index >= _visitables.get("faults").size()) { _visitables.get("faults").add(builder); } else { _visitables.get("faults").set(index, builder);}
    if (index < 0 || index >= faults.size()) { faults.add(builder); } else { faults.set(index, builder);}
     return (A)this;
  }
  public A addToFaults(io.fabric8.chaosmesh.v1alpha1.IoFault... items) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").add(builder);this.faults.add(builder);} return (A)this;
  }
  public A addAllToFaults(Collection<IoFault> items) {
    if (this.faults == null) {this.faults = new ArrayList<IoFaultBuilder>();}
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").add(builder);this.faults.add(builder);} return (A)this;
  }
  public A removeFromFaults(io.fabric8.chaosmesh.v1alpha1.IoFault... items) {
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").remove(builder);if (this.faults != null) {this.faults.remove(builder);}} return (A)this;
  }
  public A removeAllFromFaults(Collection<IoFault> items) {
    for (IoFault item : items) {IoFaultBuilder builder = new IoFaultBuilder(item);_visitables.get("faults").remove(builder);if (this.faults != null) {this.faults.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFaults(Predicate<IoFaultBuilder> predicate) {
    if (faults == null) return (A) this;
    final Iterator<IoFaultBuilder> each = faults.iterator();
    final List visitables = _visitables.get("faults");
    while (each.hasNext()) {
      IoFaultBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildFaults instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IoFault> getFaults() {
    return faults != null ? build(faults) : null;
  }
  public List<IoFault> buildFaults() {
    return faults != null ? build(faults) : null;
  }
  public IoFault buildFault(Integer index) {
    return this.faults.get(index).build();
  }
  public IoFault buildFirstFault() {
    return this.faults.get(0).build();
  }
  public IoFault buildLastFault() {
    return this.faults.get(faults.size() - 1).build();
  }
  public IoFault buildMatchingFault(Predicate<IoFaultBuilder> predicate) {
    for (IoFaultBuilder item: faults) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingFault(Predicate<IoFaultBuilder> predicate) {
    for (IoFaultBuilder item: faults) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFaults(List<IoFault> faults) {
    if (this.faults != null) { _visitables.get("faults").removeAll(this.faults);}
    if (faults != null) {this.faults = new ArrayList(); for (IoFault item : faults){this.addToFaults(item);}} else { this.faults = null;} return (A) this;
  }
  public A withFaults(io.fabric8.chaosmesh.v1alpha1.IoFault... faults) {
    if (this.faults != null) {this.faults.clear();}
    if (faults != null) {for (IoFault item :faults){ this.addToFaults(item);}} return (A) this;
  }
  public Boolean hasFaults() {
    return faults != null && !faults.isEmpty();
  }
  public A addNewFault(Integer errno,Integer weight) {
    return (A)addToFaults(new IoFault(errno, weight));
  }
  public IOChaosActionFluent.FaultsNested<A> addNewFault() {
    return new IOChaosActionFluentImpl.FaultsNestedImpl();
  }
  public IOChaosActionFluent.FaultsNested<A> addNewFaultLike(IoFault item) {
    return new IOChaosActionFluentImpl.FaultsNestedImpl(-1, item);
  }
  public IOChaosActionFluent.FaultsNested<A> setNewFaultLike(Integer index,IoFault item) {
    return new IOChaosActionFluentImpl.FaultsNestedImpl(index, item);
  }
  public IOChaosActionFluent.FaultsNested<A> editFault(Integer index) {
    if (faults.size() <= index) throw new RuntimeException("Can't edit faults. Index exceeds size.");
    return setNewFaultLike(index, buildFault(index));
  }
  public IOChaosActionFluent.FaultsNested<A> editFirstFault() {
    if (faults.size() == 0) throw new RuntimeException("Can't edit first faults. The list is empty.");
    return setNewFaultLike(0, buildFault(0));
  }
  public IOChaosActionFluent.FaultsNested<A> editLastFault() {
    int index = faults.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last faults. The list is empty.");
    return setNewFaultLike(index, buildFault(index));
  }
  public IOChaosActionFluent.FaultsNested<A> editMatchingFault(Predicate<IoFaultBuilder> predicate) {
    int index = -1;
    for (int i=0;i<faults.size();i++) { 
    if (predicate.test(faults.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching faults. No match found.");
    return setNewFaultLike(index, buildFault(index));
  }
  public Long getGid() {
    return this.gid;
  }
  public A withGid(Long gid) {
    this.gid=gid; return (A) this;
  }
  public Boolean hasGid() {
    return this.gid != null;
  }
  public Long getIno() {
    return this.ino;
  }
  public A withIno(Long ino) {
    this.ino=ino; return (A) this;
  }
  public Boolean hasIno() {
    return this.ino != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getLatency() {
    return this.latency;
  }
  public A withLatency(String latency) {
    this.latency=latency; return (A) this;
  }
  public Boolean hasLatency() {
    return this.latency != null;
  }
  public A addToMethods(Integer index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.add(index, item);
    return (A)this;
  }
  public A setToMethods(Integer index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.set(index, item); return (A)this;
  }
  public A addToMethods(java.lang.String... items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  public A addAllToMethods(Collection<String> items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  public A removeFromMethods(java.lang.String... items) {
    for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
  }
  public A removeAllFromMethods(Collection<String> items) {
    for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
  }
  public List<String> getMethods() {
    return this.methods;
  }
  public String getMethod(Integer index) {
    return this.methods.get(index);
  }
  public String getFirstMethod() {
    return this.methods.get(0);
  }
  public String getLastMethod() {
    return this.methods.get(methods.size() - 1);
  }
  public String getMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMethods(List<String> methods) {
    if (methods != null) {this.methods = new ArrayList(); for (String item : methods){this.addToMethods(item);}} else { this.methods = null;} return (A) this;
  }
  public A withMethods(java.lang.String... methods) {
    if (this.methods != null) {this.methods.clear();}
    if (methods != null) {for (String item :methods){ this.addToMethods(item);}} return (A) this;
  }
  public Boolean hasMethods() {
    return methods != null && !methods.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildMistake instead.
   * @return The buildable object.
   */
  @Deprecated
  public MistakeSpec getMistake() {
    return this.mistake!=null ?this.mistake.build():null;
  }
  public MistakeSpec buildMistake() {
    return this.mistake!=null ?this.mistake.build():null;
  }
  public A withMistake(MistakeSpec mistake) {
    _visitables.get("mistake").remove(this.mistake);
    if (mistake!=null){ this.mistake= new MistakeSpecBuilder(mistake); _visitables.get("mistake").add(this.mistake);} else { this.mistake = null; _visitables.get("mistake").remove(this.mistake); } return (A) this;
  }
  public Boolean hasMistake() {
    return this.mistake != null;
  }
  public A withNewMistake(String filling,Long maxLength,Long maxOccurrences) {
    return (A)withMistake(new MistakeSpec(filling, maxLength, maxOccurrences));
  }
  public IOChaosActionFluent.MistakeNested<A> withNewMistake() {
    return new IOChaosActionFluentImpl.MistakeNestedImpl();
  }
  public IOChaosActionFluent.MistakeNested<A> withNewMistakeLike(MistakeSpec item) {
    return new IOChaosActionFluentImpl.MistakeNestedImpl(item);
  }
  public IOChaosActionFluent.MistakeNested<A> editMistake() {
    return withNewMistakeLike(getMistake());
  }
  public IOChaosActionFluent.MistakeNested<A> editOrNewMistake() {
    return withNewMistakeLike(getMistake() != null ? getMistake(): new MistakeSpecBuilder().build());
  }
  public IOChaosActionFluent.MistakeNested<A> editOrNewMistakeLike(MistakeSpec item) {
    return withNewMistakeLike(getMistake() != null ? getMistake(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMtime instead.
   * @return The buildable object.
   */
  @Deprecated
  public Timespec getMtime() {
    return this.mtime!=null ?this.mtime.build():null;
  }
  public Timespec buildMtime() {
    return this.mtime!=null ?this.mtime.build():null;
  }
  public A withMtime(Timespec mtime) {
    _visitables.get("mtime").remove(this.mtime);
    if (mtime!=null){ this.mtime= new TimespecBuilder(mtime); _visitables.get("mtime").add(this.mtime);} else { this.mtime = null; _visitables.get("mtime").remove(this.mtime); } return (A) this;
  }
  public Boolean hasMtime() {
    return this.mtime != null;
  }
  public A withNewMtime(Long nsec,Long sec) {
    return (A)withMtime(new Timespec(nsec, sec));
  }
  public IOChaosActionFluent.MtimeNested<A> withNewMtime() {
    return new IOChaosActionFluentImpl.MtimeNestedImpl();
  }
  public IOChaosActionFluent.MtimeNested<A> withNewMtimeLike(Timespec item) {
    return new IOChaosActionFluentImpl.MtimeNestedImpl(item);
  }
  public IOChaosActionFluent.MtimeNested<A> editMtime() {
    return withNewMtimeLike(getMtime());
  }
  public IOChaosActionFluent.MtimeNested<A> editOrNewMtime() {
    return withNewMtimeLike(getMtime() != null ? getMtime(): new TimespecBuilder().build());
  }
  public IOChaosActionFluent.MtimeNested<A> editOrNewMtimeLike(Timespec item) {
    return withNewMtimeLike(getMtime() != null ? getMtime(): item);
  }
  public Long getNlink() {
    return this.nlink;
  }
  public A withNlink(Long nlink) {
    this.nlink=nlink; return (A) this;
  }
  public Boolean hasNlink() {
    return this.nlink != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public Integer getPercent() {
    return this.percent;
  }
  public A withPercent(Integer percent) {
    this.percent=percent; return (A) this;
  }
  public Boolean hasPercent() {
    return this.percent != null;
  }
  public Integer getPerm() {
    return this.perm;
  }
  public A withPerm(Integer perm) {
    this.perm=perm; return (A) this;
  }
  public Boolean hasPerm() {
    return this.perm != null;
  }
  public Long getRdev() {
    return this.rdev;
  }
  public A withRdev(Long rdev) {
    this.rdev=rdev; return (A) this;
  }
  public Boolean hasRdev() {
    return this.rdev != null;
  }
  public Long getSize() {
    return this.size;
  }
  public A withSize(Long size) {
    this.size=size; return (A) this;
  }
  public Boolean hasSize() {
    return this.size != null;
  }
  public String getSource() {
    return this.source;
  }
  public A withSource(String source) {
    this.source=source; return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public Long getUid() {
    return this.uid;
  }
  public A withUid(Long uid) {
    this.uid=uid; return (A) this;
  }
  public Boolean hasUid() {
    return this.uid != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IOChaosActionFluentImpl that = (IOChaosActionFluentImpl) o;
    if (atime != null ? !atime.equals(that.atime) :that.atime != null) return false;
    if (blocks != null ? !blocks.equals(that.blocks) :that.blocks != null) return false;
    if (ctime != null ? !ctime.equals(that.ctime) :that.ctime != null) return false;
    if (faults != null ? !faults.equals(that.faults) :that.faults != null) return false;
    if (gid != null ? !gid.equals(that.gid) :that.gid != null) return false;
    if (ino != null ? !ino.equals(that.ino) :that.ino != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (latency != null ? !latency.equals(that.latency) :that.latency != null) return false;
    if (methods != null ? !methods.equals(that.methods) :that.methods != null) return false;
    if (mistake != null ? !mistake.equals(that.mistake) :that.mistake != null) return false;
    if (mtime != null ? !mtime.equals(that.mtime) :that.mtime != null) return false;
    if (nlink != null ? !nlink.equals(that.nlink) :that.nlink != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
    if (perm != null ? !perm.equals(that.perm) :that.perm != null) return false;
    if (rdev != null ? !rdev.equals(that.rdev) :that.rdev != null) return false;
    if (size != null ? !size.equals(that.size) :that.size != null) return false;
    if (source != null ? !source.equals(that.source) :that.source != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(atime,  blocks,  ctime,  faults,  gid,  ino,  kind,  latency,  methods,  mistake,  mtime,  nlink,  path,  percent,  perm,  rdev,  size,  source,  type,  uid,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (atime != null) { sb.append("atime:"); sb.append(atime + ","); }
    if (blocks != null) { sb.append("blocks:"); sb.append(blocks + ","); }
    if (ctime != null) { sb.append("ctime:"); sb.append(ctime + ","); }
    if (faults != null && !faults.isEmpty()) { sb.append("faults:"); sb.append(faults + ","); }
    if (gid != null) { sb.append("gid:"); sb.append(gid + ","); }
    if (ino != null) { sb.append("ino:"); sb.append(ino + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (latency != null) { sb.append("latency:"); sb.append(latency + ","); }
    if (methods != null && !methods.isEmpty()) { sb.append("methods:"); sb.append(methods + ","); }
    if (mistake != null) { sb.append("mistake:"); sb.append(mistake + ","); }
    if (mtime != null) { sb.append("mtime:"); sb.append(mtime + ","); }
    if (nlink != null) { sb.append("nlink:"); sb.append(nlink + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (perm != null) { sb.append("perm:"); sb.append(perm + ","); }
    if (rdev != null) { sb.append("rdev:"); sb.append(rdev + ","); }
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid); }
    sb.append("}");
    return sb.toString();
  }
  class AtimeNestedImpl<N> extends TimespecFluentImpl<IOChaosActionFluent.AtimeNested<N>> implements IOChaosActionFluent.AtimeNested<N>,Nested<N>{
    AtimeNestedImpl(Timespec item) {
      this.builder = new TimespecBuilder(this, item);
    }
    AtimeNestedImpl() {
      this.builder = new TimespecBuilder(this);
    }
    TimespecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluentImpl.this.withAtime(builder.build());
    }
    public N endAtime() {
      return and();
    }
    
  }
  class CtimeNestedImpl<N> extends TimespecFluentImpl<IOChaosActionFluent.CtimeNested<N>> implements IOChaosActionFluent.CtimeNested<N>,Nested<N>{
    CtimeNestedImpl(Timespec item) {
      this.builder = new TimespecBuilder(this, item);
    }
    CtimeNestedImpl() {
      this.builder = new TimespecBuilder(this);
    }
    TimespecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluentImpl.this.withCtime(builder.build());
    }
    public N endCtime() {
      return and();
    }
    
  }
  class FaultsNestedImpl<N> extends IoFaultFluentImpl<IOChaosActionFluent.FaultsNested<N>> implements IOChaosActionFluent.FaultsNested<N>,Nested<N>{
    FaultsNestedImpl(Integer index,IoFault item) {
      this.index = index;
      this.builder = new IoFaultBuilder(this, item);
    }
    FaultsNestedImpl() {
      this.index = -1;
      this.builder = new IoFaultBuilder(this);
    }
    IoFaultBuilder builder;
    Integer index;
    public N and() {
      return (N) IOChaosActionFluentImpl.this.setToFaults(index,builder.build());
    }
    public N endFault() {
      return and();
    }
    
  }
  class MistakeNestedImpl<N> extends MistakeSpecFluentImpl<IOChaosActionFluent.MistakeNested<N>> implements IOChaosActionFluent.MistakeNested<N>,Nested<N>{
    MistakeNestedImpl(MistakeSpec item) {
      this.builder = new MistakeSpecBuilder(this, item);
    }
    MistakeNestedImpl() {
      this.builder = new MistakeSpecBuilder(this);
    }
    MistakeSpecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluentImpl.this.withMistake(builder.build());
    }
    public N endMistake() {
      return and();
    }
    
  }
  class MtimeNestedImpl<N> extends TimespecFluentImpl<IOChaosActionFluent.MtimeNested<N>> implements IOChaosActionFluent.MtimeNested<N>,Nested<N>{
    MtimeNestedImpl(Timespec item) {
      this.builder = new TimespecBuilder(this, item);
    }
    MtimeNestedImpl() {
      this.builder = new TimespecBuilder(this);
    }
    TimespecBuilder builder;
    public N and() {
      return (N) IOChaosActionFluentImpl.this.withMtime(builder.build());
    }
    public N endMtime() {
      return and();
    }
    
  }
  
}