package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IOChaosActionBuilder extends IOChaosActionFluentImpl<IOChaosActionBuilder> implements VisitableBuilder<IOChaosAction,IOChaosActionBuilder>{
  public IOChaosActionBuilder() {
    this(false);
  }
  public IOChaosActionBuilder(Boolean validationEnabled) {
    this(new IOChaosAction(), validationEnabled);
  }
  public IOChaosActionBuilder(IOChaosActionFluent<?> fluent) {
    this(fluent, false);
  }
  public IOChaosActionBuilder(IOChaosActionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IOChaosAction(), validationEnabled);
  }
  public IOChaosActionBuilder(IOChaosActionFluent<?> fluent,IOChaosAction instance) {
    this(fluent, instance, false);
  }
  public IOChaosActionBuilder(IOChaosActionFluent<?> fluent,IOChaosAction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAtime(instance.getAtime()); 
    fluent.withBlocks(instance.getBlocks()); 
    fluent.withCtime(instance.getCtime()); 
    fluent.withFaults(instance.getFaults()); 
    fluent.withGid(instance.getGid()); 
    fluent.withIno(instance.getIno()); 
    fluent.withKind(instance.getKind()); 
    fluent.withLatency(instance.getLatency()); 
    fluent.withMethods(instance.getMethods()); 
    fluent.withMistake(instance.getMistake()); 
    fluent.withMtime(instance.getMtime()); 
    fluent.withNlink(instance.getNlink()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPercent(instance.getPercent()); 
    fluent.withPerm(instance.getPerm()); 
    fluent.withRdev(instance.getRdev()); 
    fluent.withSize(instance.getSize()); 
    fluent.withSource(instance.getSource()); 
    fluent.withType(instance.getType()); 
    fluent.withUid(instance.getUid()); 
    this.validationEnabled = validationEnabled; 
  }
  public IOChaosActionBuilder(IOChaosAction instance) {
    this(instance,false);
  }
  public IOChaosActionBuilder(IOChaosAction instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAtime(instance.getAtime()); 
    this.withBlocks(instance.getBlocks()); 
    this.withCtime(instance.getCtime()); 
    this.withFaults(instance.getFaults()); 
    this.withGid(instance.getGid()); 
    this.withIno(instance.getIno()); 
    this.withKind(instance.getKind()); 
    this.withLatency(instance.getLatency()); 
    this.withMethods(instance.getMethods()); 
    this.withMistake(instance.getMistake()); 
    this.withMtime(instance.getMtime()); 
    this.withNlink(instance.getNlink()); 
    this.withPath(instance.getPath()); 
    this.withPercent(instance.getPercent()); 
    this.withPerm(instance.getPerm()); 
    this.withRdev(instance.getRdev()); 
    this.withSize(instance.getSize()); 
    this.withSource(instance.getSource()); 
    this.withType(instance.getType()); 
    this.withUid(instance.getUid()); 
    this.validationEnabled = validationEnabled; 
  }
  IOChaosActionFluent<?> fluent;
  Boolean validationEnabled;
  public IOChaosAction build() {
    IOChaosAction buildable = new IOChaosAction(fluent.getAtime(),fluent.getBlocks(),fluent.getCtime(),fluent.getFaults(),fluent.getGid(),fluent.getIno(),fluent.getKind(),fluent.getLatency(),fluent.getMethods(),fluent.getMistake(),fluent.getMtime(),fluent.getNlink(),fluent.getPath(),fluent.getPercent(),fluent.getPerm(),fluent.getRdev(),fluent.getSize(),fluent.getSource(),fluent.getType(),fluent.getUid());
    return buildable;
  }
  
}