package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPChaosSpecBuilder extends HTTPChaosSpecFluentImpl<HTTPChaosSpecBuilder> implements VisitableBuilder<HTTPChaosSpec,HTTPChaosSpecBuilder>{
  public HTTPChaosSpecBuilder() {
    this(false);
  }
  public HTTPChaosSpecBuilder(Boolean validationEnabled) {
    this(new HTTPChaosSpec(), validationEnabled);
  }
  public HTTPChaosSpecBuilder(HTTPChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPChaosSpecBuilder(HTTPChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPChaosSpec(), validationEnabled);
  }
  public HTTPChaosSpecBuilder(HTTPChaosSpecFluent<?> fluent,HTTPChaosSpec instance) {
    this(fluent, instance, false);
  }
  public HTTPChaosSpecBuilder(HTTPChaosSpecFluent<?> fluent,HTTPChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAbort(instance.getAbort()); 
    fluent.withCode(instance.getCode()); 
    fluent.withDelay(instance.getDelay()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withMethod(instance.getMethod()); 
    fluent.withMode(instance.getMode()); 
    fluent.withPatch(instance.getPatch()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPort(instance.getPort()); 
    fluent.withReplace(instance.getReplace()); 
    fluent.withRequestHeaders(instance.getRequestHeaders()); 
    fluent.withResponseHeaders(instance.getResponseHeaders()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTarget(instance.getTarget()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPChaosSpecBuilder(HTTPChaosSpec instance) {
    this(instance,false);
  }
  public HTTPChaosSpecBuilder(HTTPChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAbort(instance.getAbort()); 
    this.withCode(instance.getCode()); 
    this.withDelay(instance.getDelay()); 
    this.withDuration(instance.getDuration()); 
    this.withMethod(instance.getMethod()); 
    this.withMode(instance.getMode()); 
    this.withPatch(instance.getPatch()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withReplace(instance.getReplace()); 
    this.withRequestHeaders(instance.getRequestHeaders()); 
    this.withResponseHeaders(instance.getResponseHeaders()); 
    this.withSelector(instance.getSelector()); 
    this.withTarget(instance.getTarget()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  HTTPChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPChaosSpec build() {
    HTTPChaosSpec buildable = new HTTPChaosSpec(fluent.getAbort(),fluent.getCode(),fluent.getDelay(),fluent.getDuration(),fluent.getMethod(),fluent.getMode(),fluent.getPatch(),fluent.getPath(),fluent.getPort(),fluent.getReplace(),fluent.getRequestHeaders(),fluent.getResponseHeaders(),fluent.getSelector(),fluent.getTarget(),fluent.getValue());
    return buildable;
  }
  
}