package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ExperimentStatusFluentImpl<A extends ExperimentStatusFluent<A>> extends BaseFluent<A> implements ExperimentStatusFluent<A>{
  public ExperimentStatusFluentImpl() {
  }
  public ExperimentStatusFluentImpl(ExperimentStatus instance) {
    this.withContainerRecords(instance.getContainerRecords()); 
    this.withDesiredPhase(instance.getDesiredPhase()); 
  }
  private ArrayList<RecordBuilder> containerRecords = new ArrayList<RecordBuilder>();
  private String desiredPhase;
  public A addToContainerRecords(Integer index,Record item) {
    if (this.containerRecords == null) {this.containerRecords = new ArrayList<RecordBuilder>();}
    RecordBuilder builder = new RecordBuilder(item);_visitables.get("containerRecords").add(index >= 0 ? index : _visitables.get("containerRecords").size(), builder);this.containerRecords.add(index >= 0 ? index : containerRecords.size(), builder); return (A)this;
  }
  public A setToContainerRecords(Integer index,Record item) {
    if (this.containerRecords == null) {this.containerRecords = new ArrayList<RecordBuilder>();}
    RecordBuilder builder = new RecordBuilder(item);
    if (index < 0 || index >= _visitables.get("containerRecords").size()) { _visitables.get("containerRecords").add(builder); } else { _visitables.get("containerRecords").set(index, builder);}
    if (index < 0 || index >= containerRecords.size()) { containerRecords.add(builder); } else { containerRecords.set(index, builder);}
     return (A)this;
  }
  public A addToContainerRecords(io.fabric8.chaosmesh.v1alpha1.Record... items) {
    if (this.containerRecords == null) {this.containerRecords = new ArrayList<RecordBuilder>();}
    for (Record item : items) {RecordBuilder builder = new RecordBuilder(item);_visitables.get("containerRecords").add(builder);this.containerRecords.add(builder);} return (A)this;
  }
  public A addAllToContainerRecords(Collection<Record> items) {
    if (this.containerRecords == null) {this.containerRecords = new ArrayList<RecordBuilder>();}
    for (Record item : items) {RecordBuilder builder = new RecordBuilder(item);_visitables.get("containerRecords").add(builder);this.containerRecords.add(builder);} return (A)this;
  }
  public A removeFromContainerRecords(io.fabric8.chaosmesh.v1alpha1.Record... items) {
    for (Record item : items) {RecordBuilder builder = new RecordBuilder(item);_visitables.get("containerRecords").remove(builder);if (this.containerRecords != null) {this.containerRecords.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainerRecords(Collection<Record> items) {
    for (Record item : items) {RecordBuilder builder = new RecordBuilder(item);_visitables.get("containerRecords").remove(builder);if (this.containerRecords != null) {this.containerRecords.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainerRecords(Predicate<RecordBuilder> predicate) {
    if (containerRecords == null) return (A) this;
    final Iterator<RecordBuilder> each = containerRecords.iterator();
    final List visitables = _visitables.get("containerRecords");
    while (each.hasNext()) {
      RecordBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainerRecords instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Record> getContainerRecords() {
    return containerRecords != null ? build(containerRecords) : null;
  }
  public List<Record> buildContainerRecords() {
    return containerRecords != null ? build(containerRecords) : null;
  }
  public Record buildContainerRecord(Integer index) {
    return this.containerRecords.get(index).build();
  }
  public Record buildFirstContainerRecord() {
    return this.containerRecords.get(0).build();
  }
  public Record buildLastContainerRecord() {
    return this.containerRecords.get(containerRecords.size() - 1).build();
  }
  public Record buildMatchingContainerRecord(Predicate<RecordBuilder> predicate) {
    for (RecordBuilder item: containerRecords) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContainerRecord(Predicate<RecordBuilder> predicate) {
    for (RecordBuilder item: containerRecords) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerRecords(List<Record> containerRecords) {
    if (this.containerRecords != null) { _visitables.get("containerRecords").removeAll(this.containerRecords);}
    if (containerRecords != null) {this.containerRecords = new ArrayList(); for (Record item : containerRecords){this.addToContainerRecords(item);}} else { this.containerRecords = null;} return (A) this;
  }
  public A withContainerRecords(io.fabric8.chaosmesh.v1alpha1.Record... containerRecords) {
    if (this.containerRecords != null) {this.containerRecords.clear();}
    if (containerRecords != null) {for (Record item :containerRecords){ this.addToContainerRecords(item);}} return (A) this;
  }
  public Boolean hasContainerRecords() {
    return containerRecords != null && !containerRecords.isEmpty();
  }
  public A addNewContainerRecord(String id,String phase,String selectorKey) {
    return (A)addToContainerRecords(new Record(id, phase, selectorKey));
  }
  public ExperimentStatusFluent.ContainerRecordsNested<A> addNewContainerRecord() {
    return new ExperimentStatusFluentImpl.ContainerRecordsNestedImpl();
  }
  public ExperimentStatusFluent.ContainerRecordsNested<A> addNewContainerRecordLike(Record item) {
    return new ExperimentStatusFluentImpl.ContainerRecordsNestedImpl(-1, item);
  }
  public ExperimentStatusFluent.ContainerRecordsNested<A> setNewContainerRecordLike(Integer index,Record item) {
    return new ExperimentStatusFluentImpl.ContainerRecordsNestedImpl(index, item);
  }
  public ExperimentStatusFluent.ContainerRecordsNested<A> editContainerRecord(Integer index) {
    if (containerRecords.size() <= index) throw new RuntimeException("Can't edit containerRecords. Index exceeds size.");
    return setNewContainerRecordLike(index, buildContainerRecord(index));
  }
  public ExperimentStatusFluent.ContainerRecordsNested<A> editFirstContainerRecord() {
    if (containerRecords.size() == 0) throw new RuntimeException("Can't edit first containerRecords. The list is empty.");
    return setNewContainerRecordLike(0, buildContainerRecord(0));
  }
  public ExperimentStatusFluent.ContainerRecordsNested<A> editLastContainerRecord() {
    int index = containerRecords.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containerRecords. The list is empty.");
    return setNewContainerRecordLike(index, buildContainerRecord(index));
  }
  public ExperimentStatusFluent.ContainerRecordsNested<A> editMatchingContainerRecord(Predicate<RecordBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containerRecords.size();i++) { 
    if (predicate.test(containerRecords.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containerRecords. No match found.");
    return setNewContainerRecordLike(index, buildContainerRecord(index));
  }
  public String getDesiredPhase() {
    return this.desiredPhase;
  }
  public A withDesiredPhase(String desiredPhase) {
    this.desiredPhase=desiredPhase; return (A) this;
  }
  public Boolean hasDesiredPhase() {
    return this.desiredPhase != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExperimentStatusFluentImpl that = (ExperimentStatusFluentImpl) o;
    if (containerRecords != null ? !containerRecords.equals(that.containerRecords) :that.containerRecords != null) return false;
    if (desiredPhase != null ? !desiredPhase.equals(that.desiredPhase) :that.desiredPhase != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerRecords,  desiredPhase,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerRecords != null && !containerRecords.isEmpty()) { sb.append("containerRecords:"); sb.append(containerRecords + ","); }
    if (desiredPhase != null) { sb.append("desiredPhase:"); sb.append(desiredPhase); }
    sb.append("}");
    return sb.toString();
  }
  class ContainerRecordsNestedImpl<N> extends RecordFluentImpl<ExperimentStatusFluent.ContainerRecordsNested<N>> implements ExperimentStatusFluent.ContainerRecordsNested<N>,Nested<N>{
    ContainerRecordsNestedImpl(Integer index,Record item) {
      this.index = index;
      this.builder = new RecordBuilder(this, item);
    }
    ContainerRecordsNestedImpl() {
      this.index = -1;
      this.builder = new RecordBuilder(this);
    }
    RecordBuilder builder;
    Integer index;
    public N and() {
      return (N) ExperimentStatusFluentImpl.this.setToContainerRecords(index,builder.build());
    }
    public N endContainerRecord() {
      return and();
    }
    
  }
  
}