package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DiskPayloadSpecBuilder extends DiskPayloadSpecFluentImpl<DiskPayloadSpecBuilder> implements VisitableBuilder<DiskPayloadSpec,DiskPayloadSpecBuilder>{
  public DiskPayloadSpecBuilder() {
    this(false);
  }
  public DiskPayloadSpecBuilder(Boolean validationEnabled) {
    this(new DiskPayloadSpec(), validationEnabled);
  }
  public DiskPayloadSpecBuilder(DiskPayloadSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DiskPayloadSpecBuilder(DiskPayloadSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DiskPayloadSpec(), validationEnabled);
  }
  public DiskPayloadSpecBuilder(DiskPayloadSpecFluent<?> fluent,DiskPayloadSpec instance) {
    this(fluent, instance, false);
  }
  public DiskPayloadSpecBuilder(DiskPayloadSpecFluent<?> fluent,DiskPayloadSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPath(instance.getPath()); 
    fluent.withPayloadProcessNum(instance.getPayloadProcessNum()); 
    fluent.withSize(instance.getSize()); 
    this.validationEnabled = validationEnabled; 
  }
  public DiskPayloadSpecBuilder(DiskPayloadSpec instance) {
    this(instance,false);
  }
  public DiskPayloadSpecBuilder(DiskPayloadSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withPath(instance.getPath()); 
    this.withPayloadProcessNum(instance.getPayloadProcessNum()); 
    this.withSize(instance.getSize()); 
    this.validationEnabled = validationEnabled; 
  }
  DiskPayloadSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DiskPayloadSpec build() {
    DiskPayloadSpec buildable = new DiskPayloadSpec(fluent.getPath(),fluent.getPayloadProcessNum(),fluent.getSize());
    return buildable;
  }
  
}