package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSChaosBuilder extends DNSChaosFluentImpl<DNSChaosBuilder> implements VisitableBuilder<DNSChaos,DNSChaosBuilder>{
  public DNSChaosBuilder() {
    this(false);
  }
  public DNSChaosBuilder(Boolean validationEnabled) {
    this(new DNSChaos(), validationEnabled);
  }
  public DNSChaosBuilder(DNSChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSChaosBuilder(DNSChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSChaos(), validationEnabled);
  }
  public DNSChaosBuilder(DNSChaosFluent<?> fluent,DNSChaos instance) {
    this(fluent, instance, false);
  }
  public DNSChaosBuilder(DNSChaosFluent<?> fluent,DNSChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public DNSChaosBuilder(DNSChaos instance) {
    this(instance,false);
  }
  public DNSChaosBuilder(DNSChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  DNSChaosFluent<?> fluent;
  Boolean validationEnabled;
  public DNSChaos build() {
    DNSChaos buildable = new DNSChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}