package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BlockChaosBuilder extends BlockChaosFluentImpl<BlockChaosBuilder> implements VisitableBuilder<BlockChaos,BlockChaosBuilder>{
  public BlockChaosBuilder() {
    this(false);
  }
  public BlockChaosBuilder(Boolean validationEnabled) {
    this(new BlockChaos(), validationEnabled);
  }
  public BlockChaosBuilder(BlockChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public BlockChaosBuilder(BlockChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BlockChaos(), validationEnabled);
  }
  public BlockChaosBuilder(BlockChaosFluent<?> fluent,BlockChaos instance) {
    this(fluent, instance, false);
  }
  public BlockChaosBuilder(BlockChaosFluent<?> fluent,BlockChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public BlockChaosBuilder(BlockChaos instance) {
    this(instance,false);
  }
  public BlockChaosBuilder(BlockChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  BlockChaosFluent<?> fluent;
  Boolean validationEnabled;
  public BlockChaos build() {
    BlockChaos buildable = new BlockChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}