package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BandwidthSpecBuilder extends BandwidthSpecFluentImpl<BandwidthSpecBuilder> implements VisitableBuilder<BandwidthSpec,BandwidthSpecBuilder>{
  public BandwidthSpecBuilder() {
    this(false);
  }
  public BandwidthSpecBuilder(Boolean validationEnabled) {
    this(new BandwidthSpec(), validationEnabled);
  }
  public BandwidthSpecBuilder(BandwidthSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public BandwidthSpecBuilder(BandwidthSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BandwidthSpec(), validationEnabled);
  }
  public BandwidthSpecBuilder(BandwidthSpecFluent<?> fluent,BandwidthSpec instance) {
    this(fluent, instance, false);
  }
  public BandwidthSpecBuilder(BandwidthSpecFluent<?> fluent,BandwidthSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBuffer(instance.getBuffer()); 
    fluent.withLimit(instance.getLimit()); 
    fluent.withMinburst(instance.getMinburst()); 
    fluent.withPeakrate(instance.getPeakrate()); 
    fluent.withRate(instance.getRate()); 
    this.validationEnabled = validationEnabled; 
  }
  public BandwidthSpecBuilder(BandwidthSpec instance) {
    this(instance,false);
  }
  public BandwidthSpecBuilder(BandwidthSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBuffer(instance.getBuffer()); 
    this.withLimit(instance.getLimit()); 
    this.withMinburst(instance.getMinburst()); 
    this.withPeakrate(instance.getPeakrate()); 
    this.withRate(instance.getRate()); 
    this.validationEnabled = validationEnabled; 
  }
  BandwidthSpecFluent<?> fluent;
  Boolean validationEnabled;
  public BandwidthSpec build() {
    BandwidthSpec buildable = new BandwidthSpec(fluent.getBuffer(),fluent.getLimit(),fluent.getMinburst(),fluent.getPeakrate(),fluent.getRate());
    return buildable;
  }
  
}