package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RawIptablesFluentImpl<A extends RawIptablesFluent<A>> extends BaseFluent<A> implements RawIptablesFluent<A>{
  public RawIptablesFluentImpl() {
  }
  public RawIptablesFluentImpl(RawIptables instance) {
    this.withDevice(instance.getDevice()); 
    this.withDirection(instance.getDirection()); 
    this.withIpsets(instance.getIpsets()); 
    this.withName(instance.getName()); 
    this.withSource(instance.getSource()); 
  }
  private String device;
  private String direction;
  private List<String> ipsets = new ArrayList<String>();
  private String name;
  private String source;
  public String getDevice() {
    return this.device;
  }
  public A withDevice(String device) {
    this.device=device; return (A) this;
  }
  public Boolean hasDevice() {
    return this.device != null;
  }
  public String getDirection() {
    return this.direction;
  }
  public A withDirection(String direction) {
    this.direction=direction; return (A) this;
  }
  public Boolean hasDirection() {
    return this.direction != null;
  }
  public A addToIpsets(Integer index,String item) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<String>();}
    this.ipsets.add(index, item);
    return (A)this;
  }
  public A setToIpsets(Integer index,String item) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<String>();}
    this.ipsets.set(index, item); return (A)this;
  }
  public A addToIpsets(java.lang.String... items) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<String>();}
    for (String item : items) {this.ipsets.add(item);} return (A)this;
  }
  public A addAllToIpsets(Collection<String> items) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<String>();}
    for (String item : items) {this.ipsets.add(item);} return (A)this;
  }
  public A removeFromIpsets(java.lang.String... items) {
    for (String item : items) {if (this.ipsets!= null){ this.ipsets.remove(item);}} return (A)this;
  }
  public A removeAllFromIpsets(Collection<String> items) {
    for (String item : items) {if (this.ipsets!= null){ this.ipsets.remove(item);}} return (A)this;
  }
  public List<String> getIpsets() {
    return this.ipsets;
  }
  public String getIpset(Integer index) {
    return this.ipsets.get(index);
  }
  public String getFirstIpset() {
    return this.ipsets.get(0);
  }
  public String getLastIpset() {
    return this.ipsets.get(ipsets.size() - 1);
  }
  public String getMatchingIpset(Predicate<String> predicate) {
    for (String item: ipsets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingIpset(Predicate<String> predicate) {
    for (String item: ipsets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpsets(List<String> ipsets) {
    if (ipsets != null) {this.ipsets = new ArrayList(); for (String item : ipsets){this.addToIpsets(item);}} else { this.ipsets = null;} return (A) this;
  }
  public A withIpsets(java.lang.String... ipsets) {
    if (this.ipsets != null) {this.ipsets.clear();}
    if (ipsets != null) {for (String item :ipsets){ this.addToIpsets(item);}} return (A) this;
  }
  public Boolean hasIpsets() {
    return ipsets != null && !ipsets.isEmpty();
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getSource() {
    return this.source;
  }
  public A withSource(String source) {
    this.source=source; return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RawIptablesFluentImpl that = (RawIptablesFluentImpl) o;
    if (device != null ? !device.equals(that.device) :that.device != null) return false;
    if (direction != null ? !direction.equals(that.direction) :that.direction != null) return false;
    if (ipsets != null ? !ipsets.equals(that.ipsets) :that.ipsets != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (source != null ? !source.equals(that.source) :that.source != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(device,  direction,  ipsets,  name,  source,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (device != null) { sb.append("device:"); sb.append(device + ","); }
    if (direction != null) { sb.append("direction:"); sb.append(direction + ","); }
    if (ipsets != null && !ipsets.isEmpty()) { sb.append("ipsets:"); sb.append(ipsets + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (source != null) { sb.append("source:"); sb.append(source); }
    sb.append("}");
    return sb.toString();
  }
  
}