package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodNetworkChaosListBuilder extends PodNetworkChaosListFluentImpl<PodNetworkChaosListBuilder> implements VisitableBuilder<PodNetworkChaosList,PodNetworkChaosListBuilder>{
  public PodNetworkChaosListBuilder() {
    this(false);
  }
  public PodNetworkChaosListBuilder(Boolean validationEnabled) {
    this(new PodNetworkChaosList(), validationEnabled);
  }
  public PodNetworkChaosListBuilder(PodNetworkChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodNetworkChaosListBuilder(PodNetworkChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodNetworkChaosList(), validationEnabled);
  }
  public PodNetworkChaosListBuilder(PodNetworkChaosListFluent<?> fluent,PodNetworkChaosList instance) {
    this(fluent, instance, false);
  }
  public PodNetworkChaosListBuilder(PodNetworkChaosListFluent<?> fluent,PodNetworkChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodNetworkChaosListBuilder(PodNetworkChaosList instance) {
    this(instance,false);
  }
  public PodNetworkChaosListBuilder(PodNetworkChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  PodNetworkChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public PodNetworkChaosList build() {
    PodNetworkChaosList buildable = new PodNetworkChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}