package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PhysicalMachineSelectorSpecBuilder extends PhysicalMachineSelectorSpecFluentImpl<PhysicalMachineSelectorSpecBuilder> implements VisitableBuilder<PhysicalMachineSelectorSpec,PhysicalMachineSelectorSpecBuilder>{
  public PhysicalMachineSelectorSpecBuilder() {
    this(false);
  }
  public PhysicalMachineSelectorSpecBuilder(Boolean validationEnabled) {
    this(new PhysicalMachineSelectorSpec(), validationEnabled);
  }
  public PhysicalMachineSelectorSpecBuilder(PhysicalMachineSelectorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PhysicalMachineSelectorSpecBuilder(PhysicalMachineSelectorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PhysicalMachineSelectorSpec(), validationEnabled);
  }
  public PhysicalMachineSelectorSpecBuilder(PhysicalMachineSelectorSpecFluent<?> fluent,PhysicalMachineSelectorSpec instance) {
    this(fluent, instance, false);
  }
  public PhysicalMachineSelectorSpecBuilder(PhysicalMachineSelectorSpecFluent<?> fluent,PhysicalMachineSelectorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAnnotationSelectors(instance.getAnnotationSelectors()); 
    fluent.withExpressionSelectors(instance.getExpressionSelectors()); 
    fluent.withFieldSelectors(instance.getFieldSelectors()); 
    fluent.withLabelSelectors(instance.getLabelSelectors()); 
    fluent.withNamespaces(instance.getNamespaces()); 
    fluent.withPhysicalMachines(instance.getPhysicalMachines()); 
    this.validationEnabled = validationEnabled; 
  }
  public PhysicalMachineSelectorSpecBuilder(PhysicalMachineSelectorSpec instance) {
    this(instance,false);
  }
  public PhysicalMachineSelectorSpecBuilder(PhysicalMachineSelectorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAnnotationSelectors(instance.getAnnotationSelectors()); 
    this.withExpressionSelectors(instance.getExpressionSelectors()); 
    this.withFieldSelectors(instance.getFieldSelectors()); 
    this.withLabelSelectors(instance.getLabelSelectors()); 
    this.withNamespaces(instance.getNamespaces()); 
    this.withPhysicalMachines(instance.getPhysicalMachines()); 
    this.validationEnabled = validationEnabled; 
  }
  PhysicalMachineSelectorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PhysicalMachineSelectorSpec build() {
    PhysicalMachineSelectorSpec buildable = new PhysicalMachineSelectorSpec(fluent.getAnnotationSelectors(),fluent.getExpressionSelectors(),fluent.getFieldSelectors(),fluent.getLabelSelectors(),fluent.getNamespaces(),fluent.getPhysicalMachines());
    return buildable;
  }
  
}