package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PhysicalMachineChaosStatusBuilder extends PhysicalMachineChaosStatusFluentImpl<PhysicalMachineChaosStatusBuilder> implements VisitableBuilder<PhysicalMachineChaosStatus,PhysicalMachineChaosStatusBuilder>{
  public PhysicalMachineChaosStatusBuilder() {
    this(false);
  }
  public PhysicalMachineChaosStatusBuilder(Boolean validationEnabled) {
    this(new PhysicalMachineChaosStatus(), validationEnabled);
  }
  public PhysicalMachineChaosStatusBuilder(PhysicalMachineChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PhysicalMachineChaosStatusBuilder(PhysicalMachineChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PhysicalMachineChaosStatus(), validationEnabled);
  }
  public PhysicalMachineChaosStatusBuilder(PhysicalMachineChaosStatusFluent<?> fluent,PhysicalMachineChaosStatus instance) {
    this(fluent, instance, false);
  }
  public PhysicalMachineChaosStatusBuilder(PhysicalMachineChaosStatusFluent<?> fluent,PhysicalMachineChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withExperiment(instance.getExperiment()); 
    this.validationEnabled = validationEnabled; 
  }
  public PhysicalMachineChaosStatusBuilder(PhysicalMachineChaosStatus instance) {
    this(instance,false);
  }
  public PhysicalMachineChaosStatusBuilder(PhysicalMachineChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withExperiment(instance.getExperiment()); 
    this.validationEnabled = validationEnabled; 
  }
  PhysicalMachineChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PhysicalMachineChaosStatus build() {
    PhysicalMachineChaosStatus buildable = new PhysicalMachineChaosStatus(fluent.getConditions(),fluent.getExperiment());
    return buildable;
  }
  
}