package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPChaosBuilder extends HTTPChaosFluentImpl<HTTPChaosBuilder> implements VisitableBuilder<HTTPChaos,HTTPChaosBuilder>{
  public HTTPChaosBuilder() {
    this(false);
  }
  public HTTPChaosBuilder(Boolean validationEnabled) {
    this(new HTTPChaos(), validationEnabled);
  }
  public HTTPChaosBuilder(HTTPChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPChaosBuilder(HTTPChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPChaos(), validationEnabled);
  }
  public HTTPChaosBuilder(HTTPChaosFluent<?> fluent,HTTPChaos instance) {
    this(fluent, instance, false);
  }
  public HTTPChaosBuilder(HTTPChaosFluent<?> fluent,HTTPChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPChaosBuilder(HTTPChaos instance) {
    this(instance,false);
  }
  public HTTPChaosBuilder(HTTPChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  HTTPChaosFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPChaos build() {
    HTTPChaos buildable = new HTTPChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}