package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPChaosSpecBuilder extends GCPChaosSpecFluentImpl<GCPChaosSpecBuilder> implements VisitableBuilder<GCPChaosSpec,GCPChaosSpecBuilder>{
  public GCPChaosSpecBuilder() {
    this(false);
  }
  public GCPChaosSpecBuilder(Boolean validationEnabled) {
    this(new GCPChaosSpec(), validationEnabled);
  }
  public GCPChaosSpecBuilder(GCPChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPChaosSpecBuilder(GCPChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCPChaosSpec(), validationEnabled);
  }
  public GCPChaosSpecBuilder(GCPChaosSpecFluent<?> fluent,GCPChaosSpec instance) {
    this(fluent, instance, false);
  }
  public GCPChaosSpecBuilder(GCPChaosSpecFluent<?> fluent,GCPChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAction(instance.getAction()); 
    fluent.withDeviceNames(instance.getDeviceNames()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withInstance(instance.getInstance()); 
    fluent.withProject(instance.getProject()); 
    fluent.withSecretName(instance.getSecretName()); 
    fluent.withZone(instance.getZone()); 
    this.validationEnabled = validationEnabled; 
  }
  public GCPChaosSpecBuilder(GCPChaosSpec instance) {
    this(instance,false);
  }
  public GCPChaosSpecBuilder(GCPChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAction(instance.getAction()); 
    this.withDeviceNames(instance.getDeviceNames()); 
    this.withDuration(instance.getDuration()); 
    this.withInstance(instance.getInstance()); 
    this.withProject(instance.getProject()); 
    this.withSecretName(instance.getSecretName()); 
    this.withZone(instance.getZone()); 
    this.validationEnabled = validationEnabled; 
  }
  GCPChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public GCPChaosSpec build() {
    GCPChaosSpec buildable = new GCPChaosSpec(fluent.getAction(),fluent.getDeviceNames(),fluent.getDuration(),fluent.getInstance(),fluent.getProject(),fluent.getSecretName(),fluent.getZone());
    return buildable;
  }
  
}