package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSChaosStatusBuilder extends DNSChaosStatusFluentImpl<DNSChaosStatusBuilder> implements VisitableBuilder<DNSChaosStatus,DNSChaosStatusBuilder>{
  public DNSChaosStatusBuilder() {
    this(false);
  }
  public DNSChaosStatusBuilder(Boolean validationEnabled) {
    this(new DNSChaosStatus(), validationEnabled);
  }
  public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSChaosStatus(), validationEnabled);
  }
  public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent,DNSChaosStatus instance) {
    this(fluent, instance, false);
  }
  public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent,DNSChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withExperiment(instance.getExperiment()); 
    this.validationEnabled = validationEnabled; 
  }
  public DNSChaosStatusBuilder(DNSChaosStatus instance) {
    this(instance,false);
  }
  public DNSChaosStatusBuilder(DNSChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withExperiment(instance.getExperiment()); 
    this.validationEnabled = validationEnabled; 
  }
  DNSChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public DNSChaosStatus build() {
    DNSChaosStatus buildable = new DNSChaosStatus(fluent.getConditions(),fluent.getExperiment());
    return buildable;
  }
  
}