package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CorruptSpecBuilder extends CorruptSpecFluentImpl<CorruptSpecBuilder> implements VisitableBuilder<CorruptSpec,CorruptSpecBuilder>{
  public CorruptSpecBuilder() {
    this(false);
  }
  public CorruptSpecBuilder(Boolean validationEnabled) {
    this(new CorruptSpec(), validationEnabled);
  }
  public CorruptSpecBuilder(CorruptSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CorruptSpecBuilder(CorruptSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CorruptSpec(), validationEnabled);
  }
  public CorruptSpecBuilder(CorruptSpecFluent<?> fluent,CorruptSpec instance) {
    this(fluent, instance, false);
  }
  public CorruptSpecBuilder(CorruptSpecFluent<?> fluent,CorruptSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCorrelation(instance.getCorrelation()); 
    fluent.withCorrupt(instance.getCorrupt()); 
    this.validationEnabled = validationEnabled; 
  }
  public CorruptSpecBuilder(CorruptSpec instance) {
    this(instance,false);
  }
  public CorruptSpecBuilder(CorruptSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCorrelation(instance.getCorrelation()); 
    this.withCorrupt(instance.getCorrupt()); 
    this.validationEnabled = validationEnabled; 
  }
  CorruptSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CorruptSpec build() {
    CorruptSpec buildable = new CorruptSpec(fluent.getCorrelation(),fluent.getCorrupt());
    return buildable;
  }
  
}