package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StressorsBuilder extends StressorsFluentImpl<StressorsBuilder> implements VisitableBuilder<Stressors,StressorsBuilder>{
  public StressorsBuilder() {
    this(false);
  }
  public StressorsBuilder(Boolean validationEnabled) {
    this(new Stressors(), validationEnabled);
  }
  public StressorsBuilder(StressorsFluent<?> fluent) {
    this(fluent, false);
  }
  public StressorsBuilder(StressorsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Stressors(), validationEnabled);
  }
  public StressorsBuilder(StressorsFluent<?> fluent,Stressors instance) {
    this(fluent, instance, false);
  }
  public StressorsBuilder(StressorsFluent<?> fluent,Stressors instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCpu(instance.getCpu()); 
    fluent.withMemory(instance.getMemory()); 
    this.validationEnabled = validationEnabled; 
  }
  public StressorsBuilder(Stressors instance) {
    this(instance,false);
  }
  public StressorsBuilder(Stressors instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCpu(instance.getCpu()); 
    this.withMemory(instance.getMemory()); 
    this.validationEnabled = validationEnabled; 
  }
  StressorsFluent<?> fluent;
  Boolean validationEnabled;
  public Stressors build() {
    Stressors buildable = new Stressors(fluent.getCpu(),fluent.getMemory());
    return buildable;
  }
  
}