package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IoFaultBuilder extends IoFaultFluentImpl<IoFaultBuilder> implements VisitableBuilder<IoFault,IoFaultBuilder>{
  public IoFaultBuilder() {
    this(false);
  }
  public IoFaultBuilder(Boolean validationEnabled) {
    this(new IoFault(), validationEnabled);
  }
  public IoFaultBuilder(IoFaultFluent<?> fluent) {
    this(fluent, false);
  }
  public IoFaultBuilder(IoFaultFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IoFault(), validationEnabled);
  }
  public IoFaultBuilder(IoFaultFluent<?> fluent,IoFault instance) {
    this(fluent, instance, false);
  }
  public IoFaultBuilder(IoFaultFluent<?> fluent,IoFault instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withErrno(instance.getErrno()); 
    fluent.withWeight(instance.getWeight()); 
    this.validationEnabled = validationEnabled; 
  }
  public IoFaultBuilder(IoFault instance) {
    this(instance,false);
  }
  public IoFaultBuilder(IoFault instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withErrno(instance.getErrno()); 
    this.withWeight(instance.getWeight()); 
    this.validationEnabled = validationEnabled; 
  }
  IoFaultFluent<?> fluent;
  Boolean validationEnabled;
  public IoFault build() {
    IoFault buildable = new IoFault(fluent.getErrno(),fluent.getWeight());
    return buildable;
  }
  
}