package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IOChaosSpecBuilder extends IOChaosSpecFluentImpl<IOChaosSpecBuilder> implements VisitableBuilder<IOChaosSpec,IOChaosSpecBuilder>{
  public IOChaosSpecBuilder() {
    this(false);
  }
  public IOChaosSpecBuilder(Boolean validationEnabled) {
    this(new IOChaosSpec(), validationEnabled);
  }
  public IOChaosSpecBuilder(IOChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IOChaosSpecBuilder(IOChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IOChaosSpec(), validationEnabled);
  }
  public IOChaosSpecBuilder(IOChaosSpecFluent<?> fluent,IOChaosSpec instance) {
    this(fluent, instance, false);
  }
  public IOChaosSpecBuilder(IOChaosSpecFluent<?> fluent,IOChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAction(instance.getAction()); 
    fluent.withAttr(instance.getAttr()); 
    fluent.withContainerNames(instance.getContainerNames()); 
    fluent.withDelay(instance.getDelay()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withErrno(instance.getErrno()); 
    fluent.withMethods(instance.getMethods()); 
    fluent.withMistake(instance.getMistake()); 
    fluent.withMode(instance.getMode()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPercent(instance.getPercent()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withValue(instance.getValue()); 
    fluent.withVolumePath(instance.getVolumePath()); 
    this.validationEnabled = validationEnabled; 
  }
  public IOChaosSpecBuilder(IOChaosSpec instance) {
    this(instance,false);
  }
  public IOChaosSpecBuilder(IOChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAction(instance.getAction()); 
    this.withAttr(instance.getAttr()); 
    this.withContainerNames(instance.getContainerNames()); 
    this.withDelay(instance.getDelay()); 
    this.withDuration(instance.getDuration()); 
    this.withErrno(instance.getErrno()); 
    this.withMethods(instance.getMethods()); 
    this.withMistake(instance.getMistake()); 
    this.withMode(instance.getMode()); 
    this.withPath(instance.getPath()); 
    this.withPercent(instance.getPercent()); 
    this.withSelector(instance.getSelector()); 
    this.withValue(instance.getValue()); 
    this.withVolumePath(instance.getVolumePath()); 
    this.validationEnabled = validationEnabled; 
  }
  IOChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IOChaosSpec build() {
    IOChaosSpec buildable = new IOChaosSpec(fluent.getAction(),fluent.getAttr(),fluent.getContainerNames(),fluent.getDelay(),fluent.getDuration(),fluent.getErrno(),fluent.getMethods(),fluent.getMistake(),fluent.getMode(),fluent.getPath(),fluent.getPercent(),fluent.getSelector(),fluent.getValue(),fluent.getVolumePath());
    return buildable;
  }
  
}