package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IOChaosListBuilder extends IOChaosListFluentImpl<IOChaosListBuilder> implements VisitableBuilder<IOChaosList,IOChaosListBuilder>{
  public IOChaosListBuilder() {
    this(false);
  }
  public IOChaosListBuilder(Boolean validationEnabled) {
    this(new IOChaosList(), validationEnabled);
  }
  public IOChaosListBuilder(IOChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public IOChaosListBuilder(IOChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IOChaosList(), validationEnabled);
  }
  public IOChaosListBuilder(IOChaosListFluent<?> fluent,IOChaosList instance) {
    this(fluent, instance, false);
  }
  public IOChaosListBuilder(IOChaosListFluent<?> fluent,IOChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public IOChaosListBuilder(IOChaosList instance) {
    this(instance,false);
  }
  public IOChaosListBuilder(IOChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  IOChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public IOChaosList build() {
    IOChaosList buildable = new IOChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}