package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GCPChaosSpecFluentImpl<A extends GCPChaosSpecFluent<A>> extends BaseFluent<A> implements GCPChaosSpecFluent<A>{
  public GCPChaosSpecFluentImpl() {
  }
  public GCPChaosSpecFluentImpl(GCPChaosSpec instance) {
    this.withAction(instance.getAction()); 
    this.withDeviceNames(instance.getDeviceNames()); 
    this.withDuration(instance.getDuration()); 
    this.withInstance(instance.getInstance()); 
    this.withProject(instance.getProject()); 
    this.withSecretName(instance.getSecretName()); 
    this.withZone(instance.getZone()); 
  }
  private String action;
  private List<String> deviceNames = new ArrayList<String>();
  private String duration;
  private String instance;
  private String project;
  private String secretName;
  private String zone;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public A addToDeviceNames(Integer index,String item) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    this.deviceNames.add(index, item);
    return (A)this;
  }
  public A setToDeviceNames(Integer index,String item) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    this.deviceNames.set(index, item); return (A)this;
  }
  public A addToDeviceNames(java.lang.String... items) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    for (String item : items) {this.deviceNames.add(item);} return (A)this;
  }
  public A addAllToDeviceNames(Collection<String> items) {
    if (this.deviceNames == null) {this.deviceNames = new ArrayList<String>();}
    for (String item : items) {this.deviceNames.add(item);} return (A)this;
  }
  public A removeFromDeviceNames(java.lang.String... items) {
    for (String item : items) {if (this.deviceNames!= null){ this.deviceNames.remove(item);}} return (A)this;
  }
  public A removeAllFromDeviceNames(Collection<String> items) {
    for (String item : items) {if (this.deviceNames!= null){ this.deviceNames.remove(item);}} return (A)this;
  }
  public List<String> getDeviceNames() {
    return this.deviceNames;
  }
  public String getDeviceName(Integer index) {
    return this.deviceNames.get(index);
  }
  public String getFirstDeviceName() {
    return this.deviceNames.get(0);
  }
  public String getLastDeviceName() {
    return this.deviceNames.get(deviceNames.size() - 1);
  }
  public String getMatchingDeviceName(Predicate<String> predicate) {
    for (String item: deviceNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDeviceName(Predicate<String> predicate) {
    for (String item: deviceNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDeviceNames(List<String> deviceNames) {
    if (deviceNames != null) {this.deviceNames = new ArrayList(); for (String item : deviceNames){this.addToDeviceNames(item);}} else { this.deviceNames = null;} return (A) this;
  }
  public A withDeviceNames(java.lang.String... deviceNames) {
    if (this.deviceNames != null) {this.deviceNames.clear();}
    if (deviceNames != null) {for (String item :deviceNames){ this.addToDeviceNames(item);}} return (A) this;
  }
  public Boolean hasDeviceNames() {
    return deviceNames != null && !deviceNames.isEmpty();
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public String getInstance() {
    return this.instance;
  }
  public A withInstance(String instance) {
    this.instance=instance; return (A) this;
  }
  public Boolean hasInstance() {
    return this.instance != null;
  }
  public String getProject() {
    return this.project;
  }
  public A withProject(String project) {
    this.project=project; return (A) this;
  }
  public Boolean hasProject() {
    return this.project != null;
  }
  public String getSecretName() {
    return this.secretName;
  }
  public A withSecretName(String secretName) {
    this.secretName=secretName; return (A) this;
  }
  public Boolean hasSecretName() {
    return this.secretName != null;
  }
  public String getZone() {
    return this.zone;
  }
  public A withZone(String zone) {
    this.zone=zone; return (A) this;
  }
  public Boolean hasZone() {
    return this.zone != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GCPChaosSpecFluentImpl that = (GCPChaosSpecFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (deviceNames != null ? !deviceNames.equals(that.deviceNames) :that.deviceNames != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (instance != null ? !instance.equals(that.instance) :that.instance != null) return false;
    if (project != null ? !project.equals(that.project) :that.project != null) return false;
    if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
    if (zone != null ? !zone.equals(that.zone) :that.zone != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  deviceNames,  duration,  instance,  project,  secretName,  zone,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (deviceNames != null && !deviceNames.isEmpty()) { sb.append("deviceNames:"); sb.append(deviceNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (instance != null) { sb.append("instance:"); sb.append(instance + ","); }
    if (project != null) { sb.append("project:"); sb.append(project + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone); }
    sb.append("}");
    return sb.toString();
  }
  
}