/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.GCPChaosSpec;
import io.fabric8.chaosmesh.v1alpha1.GCPChaosSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class GCPChaosSpecFluentImpl<A extends GCPChaosSpecFluent<A>>
extends BaseFluent<A>
implements GCPChaosSpecFluent<A> {
    private String action;
    private List<String> deviceNames = new ArrayList<String>();
    private String duration;
    private String instance;
    private String project;
    private String secretName;
    private String zone;

    public GCPChaosSpecFluentImpl() {
    }

    public GCPChaosSpecFluentImpl(GCPChaosSpec instance) {
        this.withAction(instance.getAction());
        this.withDeviceNames(instance.getDeviceNames());
        this.withDuration(instance.getDuration());
        this.withInstance(instance.getInstance());
        this.withProject(instance.getProject());
        this.withSecretName(instance.getSecretName());
        this.withZone(instance.getZone());
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    @Override
    public Boolean hasAction() {
        return this.action != null;
    }

    @Override
    public A addToDeviceNames(Integer index, String item) {
        if (this.deviceNames == null) {
            this.deviceNames = new ArrayList<String>();
        }
        this.deviceNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDeviceNames(Integer index, String item) {
        if (this.deviceNames == null) {
            this.deviceNames = new ArrayList<String>();
        }
        this.deviceNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDeviceNames(String ... items) {
        if (this.deviceNames == null) {
            this.deviceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.deviceNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDeviceNames(Collection<String> items) {
        if (this.deviceNames == null) {
            this.deviceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.deviceNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDeviceNames(String ... items) {
        for (String item : items) {
            if (this.deviceNames == null) continue;
            this.deviceNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDeviceNames(Collection<String> items) {
        for (String item : items) {
            if (this.deviceNames == null) continue;
            this.deviceNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDeviceNames() {
        return this.deviceNames;
    }

    @Override
    public String getDeviceName(Integer index) {
        return this.deviceNames.get(index);
    }

    @Override
    public String getFirstDeviceName() {
        return this.deviceNames.get(0);
    }

    @Override
    public String getLastDeviceName() {
        return this.deviceNames.get(this.deviceNames.size() - 1);
    }

    @Override
    public String getMatchingDeviceName(Predicate<String> predicate) {
        for (String item : this.deviceNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDeviceName(Predicate<String> predicate) {
        for (String item : this.deviceNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDeviceNames(List<String> deviceNames) {
        if (deviceNames != null) {
            this.deviceNames = new ArrayList<String>();
            for (String item : deviceNames) {
                this.addToDeviceNames(item);
            }
        } else {
            this.deviceNames = null;
        }
        return (A)this;
    }

    @Override
    public A withDeviceNames(String ... deviceNames) {
        if (this.deviceNames != null) {
            this.deviceNames.clear();
        }
        if (deviceNames != null) {
            for (String item : deviceNames) {
                this.addToDeviceNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDeviceNames() {
        return this.deviceNames != null && !this.deviceNames.isEmpty();
    }

    @Override
    public String getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(String duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public String getInstance() {
        return this.instance;
    }

    @Override
    public A withInstance(String instance) {
        this.instance = instance;
        return (A)this;
    }

    @Override
    public Boolean hasInstance() {
        return this.instance != null;
    }

    @Override
    public String getProject() {
        return this.project;
    }

    @Override
    public A withProject(String project) {
        this.project = project;
        return (A)this;
    }

    @Override
    public Boolean hasProject() {
        return this.project != null;
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    public String getZone() {
        return this.zone;
    }

    @Override
    public A withZone(String zone) {
        this.zone = zone;
        return (A)this;
    }

    @Override
    public Boolean hasZone() {
        return this.zone != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GCPChaosSpecFluentImpl that = (GCPChaosSpecFluentImpl)o;
        if (this.action != null ? !this.action.equals(that.action) : that.action != null) {
            return false;
        }
        if (this.deviceNames != null ? !this.deviceNames.equals(that.deviceNames) : that.deviceNames != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals(that.duration) : that.duration != null) {
            return false;
        }
        if (this.instance != null ? !this.instance.equals(that.instance) : that.instance != null) {
            return false;
        }
        if (this.project != null ? !this.project.equals(that.project) : that.project != null) {
            return false;
        }
        if (this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null) {
            return false;
        }
        return !(this.zone != null ? !this.zone.equals(that.zone) : that.zone != null);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.deviceNames, this.duration, this.instance, this.project, this.secretName, this.zone, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.deviceNames != null && !this.deviceNames.isEmpty()) {
            sb.append("deviceNames:");
            sb.append(this.deviceNames + ",");
        }
        if (this.duration != null) {
            sb.append("duration:");
            sb.append(this.duration + ",");
        }
        if (this.instance != null) {
            sb.append("instance:");
            sb.append(this.instance + ",");
        }
        if (this.project != null) {
            sb.append("project:");
            sb.append(this.project + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone);
        }
        sb.append("}");
        return sb.toString();
    }
}

