package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StressMemorySpecBuilder extends StressMemorySpecFluentImpl<StressMemorySpecBuilder> implements VisitableBuilder<StressMemorySpec,StressMemorySpecBuilder>{
  public StressMemorySpecBuilder() {
    this(false);
  }
  public StressMemorySpecBuilder(Boolean validationEnabled) {
    this(new StressMemorySpec(), validationEnabled);
  }
  public StressMemorySpecBuilder(StressMemorySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StressMemorySpecBuilder(StressMemorySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StressMemorySpec(), validationEnabled);
  }
  public StressMemorySpecBuilder(StressMemorySpecFluent<?> fluent,StressMemorySpec instance) {
    this(fluent, instance, false);
  }
  public StressMemorySpecBuilder(StressMemorySpecFluent<?> fluent,StressMemorySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withOptions(instance.getOptions()); 
    fluent.withSize(instance.getSize()); 
    this.validationEnabled = validationEnabled; 
  }
  public StressMemorySpecBuilder(StressMemorySpec instance) {
    this(instance,false);
  }
  public StressMemorySpecBuilder(StressMemorySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withOptions(instance.getOptions()); 
    this.withSize(instance.getSize()); 
    this.validationEnabled = validationEnabled; 
  }
  StressMemorySpecFluent<?> fluent;
  Boolean validationEnabled;
  public StressMemorySpec build() {
    StressMemorySpec buildable = new StressMemorySpec(fluent.getOptions(),fluent.getSize());
    return buildable;
  }
  
}