package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StressChaosSpecFluentImpl<A extends StressChaosSpecFluent<A>> extends BaseFluent<A> implements StressChaosSpecFluent<A>{
  public StressChaosSpecFluentImpl() {
  }
  public StressChaosSpecFluentImpl(StressChaosSpec instance) {
    this.withContainerNames(instance.getContainerNames()); 
    this.withDuration(instance.getDuration()); 
    this.withMode(instance.getMode()); 
    this.withSelector(instance.getSelector()); 
    this.withStressngStressors(instance.getStressngStressors()); 
    this.withStressors(instance.getStressors()); 
    this.withValue(instance.getValue()); 
  }
  private List<String> containerNames = new ArrayList<String>();
  private String duration;
  private String mode;
  private PodSelectorSpecBuilder selector;
  private String stressngStressors;
  private StressorsBuilder stressors;
  private String value;
  public A addToContainerNames(Integer index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.add(index, item);
    return (A)this;
  }
  public A setToContainerNames(Integer index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.set(index, item); return (A)this;
  }
  public A addToContainerNames(java.lang.String... items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A addAllToContainerNames(Collection<String> items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A removeFromContainerNames(java.lang.String... items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public A removeAllFromContainerNames(Collection<String> items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public List<String> getContainerNames() {
    return this.containerNames;
  }
  public String getContainerName(Integer index) {
    return this.containerNames.get(index);
  }
  public String getFirstContainerName() {
    return this.containerNames.get(0);
  }
  public String getLastContainerName() {
    return this.containerNames.get(containerNames.size() - 1);
  }
  public String getMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerNames(List<String> containerNames) {
    if (containerNames != null) {this.containerNames = new ArrayList(); for (String item : containerNames){this.addToContainerNames(item);}} else { this.containerNames = null;} return (A) this;
  }
  public A withContainerNames(java.lang.String... containerNames) {
    if (this.containerNames != null) {this.containerNames.clear();}
    if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
  }
  public Boolean hasContainerNames() {
    return containerNames != null && !containerNames.isEmpty();
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public PodSelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(PodSelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new PodSelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public StressChaosSpecFluent.SelectorNested<A> withNewSelector() {
    return new StressChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public StressChaosSpecFluent.SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
    return new StressChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public StressChaosSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public StressChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new PodSelectorSpecBuilder().build());
  }
  public StressChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getStressngStressors() {
    return this.stressngStressors;
  }
  public A withStressngStressors(String stressngStressors) {
    this.stressngStressors=stressngStressors; return (A) this;
  }
  public Boolean hasStressngStressors() {
    return this.stressngStressors != null;
  }
  
  /**
   * This method has been deprecated, please use method buildStressors instead.
   * @return The buildable object.
   */
  @Deprecated
  public Stressors getStressors() {
    return this.stressors!=null ?this.stressors.build():null;
  }
  public Stressors buildStressors() {
    return this.stressors!=null ?this.stressors.build():null;
  }
  public A withStressors(Stressors stressors) {
    _visitables.get("stressors").remove(this.stressors);
    if (stressors!=null){ this.stressors= new StressorsBuilder(stressors); _visitables.get("stressors").add(this.stressors);} else { this.stressors = null; _visitables.get("stressors").remove(this.stressors); } return (A) this;
  }
  public Boolean hasStressors() {
    return this.stressors != null;
  }
  public StressChaosSpecFluent.StressorsNested<A> withNewStressors() {
    return new StressChaosSpecFluentImpl.StressorsNestedImpl();
  }
  public StressChaosSpecFluent.StressorsNested<A> withNewStressorsLike(Stressors item) {
    return new StressChaosSpecFluentImpl.StressorsNestedImpl(item);
  }
  public StressChaosSpecFluent.StressorsNested<A> editStressors() {
    return withNewStressorsLike(getStressors());
  }
  public StressChaosSpecFluent.StressorsNested<A> editOrNewStressors() {
    return withNewStressorsLike(getStressors() != null ? getStressors(): new StressorsBuilder().build());
  }
  public StressChaosSpecFluent.StressorsNested<A> editOrNewStressorsLike(Stressors item) {
    return withNewStressorsLike(getStressors() != null ? getStressors(): item);
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StressChaosSpecFluentImpl that = (StressChaosSpecFluentImpl) o;
    if (containerNames != null ? !containerNames.equals(that.containerNames) :that.containerNames != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (stressngStressors != null ? !stressngStressors.equals(that.stressngStressors) :that.stressngStressors != null) return false;
    if (stressors != null ? !stressors.equals(that.stressors) :that.stressors != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerNames,  duration,  mode,  selector,  stressngStressors,  stressors,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerNames != null && !containerNames.isEmpty()) { sb.append("containerNames:"); sb.append(containerNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (stressngStressors != null) { sb.append("stressngStressors:"); sb.append(stressngStressors + ","); }
    if (stressors != null) { sb.append("stressors:"); sb.append(stressors + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  class SelectorNestedImpl<N> extends PodSelectorSpecFluentImpl<StressChaosSpecFluent.SelectorNested<N>> implements StressChaosSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(PodSelectorSpec item) {
      this.builder = new PodSelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new PodSelectorSpecBuilder(this);
    }
    PodSelectorSpecBuilder builder;
    public N and() {
      return (N) StressChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class StressorsNestedImpl<N> extends StressorsFluentImpl<StressChaosSpecFluent.StressorsNested<N>> implements StressChaosSpecFluent.StressorsNested<N>,Nested<N>{
    StressorsNestedImpl(Stressors item) {
      this.builder = new StressorsBuilder(this, item);
    }
    StressorsNestedImpl() {
      this.builder = new StressorsBuilder(this);
    }
    StressorsBuilder builder;
    public N and() {
      return (N) StressChaosSpecFluentImpl.this.withStressors(builder.build());
    }
    public N endStressors() {
      return and();
    }
    
  }
  
}