package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodNetworkChaosSpecFluentImpl<A extends PodNetworkChaosSpecFluent<A>> extends BaseFluent<A> implements PodNetworkChaosSpecFluent<A>{
  public PodNetworkChaosSpecFluentImpl() {
  }
  public PodNetworkChaosSpecFluentImpl(PodNetworkChaosSpec instance) {
    this.withIpsets(instance.getIpsets()); 
    this.withIptables(instance.getIptables()); 
    this.withTcs(instance.getTcs()); 
  }
  private ArrayList<RawIPSetBuilder> ipsets = new ArrayList<RawIPSetBuilder>();
  private ArrayList<RawIptablesBuilder> iptables = new ArrayList<RawIptablesBuilder>();
  private ArrayList<RawTrafficControlBuilder> tcs = new ArrayList<RawTrafficControlBuilder>();
  public A addToIpsets(Integer index,RawIPSet item) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
    RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").add(index >= 0 ? index : _visitables.get("ipsets").size(), builder);this.ipsets.add(index >= 0 ? index : ipsets.size(), builder); return (A)this;
  }
  public A setToIpsets(Integer index,RawIPSet item) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
    RawIPSetBuilder builder = new RawIPSetBuilder(item);
    if (index < 0 || index >= _visitables.get("ipsets").size()) { _visitables.get("ipsets").add(builder); } else { _visitables.get("ipsets").set(index, builder);}
    if (index < 0 || index >= ipsets.size()) { ipsets.add(builder); } else { ipsets.set(index, builder);}
     return (A)this;
  }
  public A addToIpsets(io.fabric8.chaosmesh.v1alpha1.RawIPSet... items) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
    for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").add(builder);this.ipsets.add(builder);} return (A)this;
  }
  public A addAllToIpsets(Collection<RawIPSet> items) {
    if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
    for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").add(builder);this.ipsets.add(builder);} return (A)this;
  }
  public A removeFromIpsets(io.fabric8.chaosmesh.v1alpha1.RawIPSet... items) {
    for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").remove(builder);if (this.ipsets != null) {this.ipsets.remove(builder);}} return (A)this;
  }
  public A removeAllFromIpsets(Collection<RawIPSet> items) {
    for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").remove(builder);if (this.ipsets != null) {this.ipsets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIpsets(Predicate<RawIPSetBuilder> predicate) {
    if (ipsets == null) return (A) this;
    final Iterator<RawIPSetBuilder> each = ipsets.iterator();
    final List visitables = _visitables.get("ipsets");
    while (each.hasNext()) {
      RawIPSetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildIpsets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RawIPSet> getIpsets() {
    return ipsets != null ? build(ipsets) : null;
  }
  public List<RawIPSet> buildIpsets() {
    return ipsets != null ? build(ipsets) : null;
  }
  public RawIPSet buildIpset(Integer index) {
    return this.ipsets.get(index).build();
  }
  public RawIPSet buildFirstIpset() {
    return this.ipsets.get(0).build();
  }
  public RawIPSet buildLastIpset() {
    return this.ipsets.get(ipsets.size() - 1).build();
  }
  public RawIPSet buildMatchingIpset(Predicate<RawIPSetBuilder> predicate) {
    for (RawIPSetBuilder item: ipsets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingIpset(Predicate<RawIPSetBuilder> predicate) {
    for (RawIPSetBuilder item: ipsets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpsets(List<RawIPSet> ipsets) {
    if (this.ipsets != null) { _visitables.get("ipsets").removeAll(this.ipsets);}
    if (ipsets != null) {this.ipsets = new ArrayList(); for (RawIPSet item : ipsets){this.addToIpsets(item);}} else { this.ipsets = null;} return (A) this;
  }
  public A withIpsets(io.fabric8.chaosmesh.v1alpha1.RawIPSet... ipsets) {
    if (this.ipsets != null) {this.ipsets.clear();}
    if (ipsets != null) {for (RawIPSet item :ipsets){ this.addToIpsets(item);}} return (A) this;
  }
  public Boolean hasIpsets() {
    return ipsets != null && !ipsets.isEmpty();
  }
  public PodNetworkChaosSpecFluent.IpsetsNested<A> addNewIpset() {
    return new PodNetworkChaosSpecFluentImpl.IpsetsNestedImpl();
  }
  public PodNetworkChaosSpecFluent.IpsetsNested<A> addNewIpsetLike(RawIPSet item) {
    return new PodNetworkChaosSpecFluentImpl.IpsetsNestedImpl(-1, item);
  }
  public PodNetworkChaosSpecFluent.IpsetsNested<A> setNewIpsetLike(Integer index,RawIPSet item) {
    return new PodNetworkChaosSpecFluentImpl.IpsetsNestedImpl(index, item);
  }
  public PodNetworkChaosSpecFluent.IpsetsNested<A> editIpset(Integer index) {
    if (ipsets.size() <= index) throw new RuntimeException("Can't edit ipsets. Index exceeds size.");
    return setNewIpsetLike(index, buildIpset(index));
  }
  public PodNetworkChaosSpecFluent.IpsetsNested<A> editFirstIpset() {
    if (ipsets.size() == 0) throw new RuntimeException("Can't edit first ipsets. The list is empty.");
    return setNewIpsetLike(0, buildIpset(0));
  }
  public PodNetworkChaosSpecFluent.IpsetsNested<A> editLastIpset() {
    int index = ipsets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ipsets. The list is empty.");
    return setNewIpsetLike(index, buildIpset(index));
  }
  public PodNetworkChaosSpecFluent.IpsetsNested<A> editMatchingIpset(Predicate<RawIPSetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ipsets.size();i++) { 
    if (predicate.test(ipsets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ipsets. No match found.");
    return setNewIpsetLike(index, buildIpset(index));
  }
  public A addToIptables(Integer index,RawIptables item) {
    if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
    RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").add(index >= 0 ? index : _visitables.get("iptables").size(), builder);this.iptables.add(index >= 0 ? index : iptables.size(), builder); return (A)this;
  }
  public A setToIptables(Integer index,RawIptables item) {
    if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
    RawIptablesBuilder builder = new RawIptablesBuilder(item);
    if (index < 0 || index >= _visitables.get("iptables").size()) { _visitables.get("iptables").add(builder); } else { _visitables.get("iptables").set(index, builder);}
    if (index < 0 || index >= iptables.size()) { iptables.add(builder); } else { iptables.set(index, builder);}
     return (A)this;
  }
  public A addToIptables(io.fabric8.chaosmesh.v1alpha1.RawIptables... items) {
    if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
    for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").add(builder);this.iptables.add(builder);} return (A)this;
  }
  public A addAllToIptables(Collection<RawIptables> items) {
    if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
    for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").add(builder);this.iptables.add(builder);} return (A)this;
  }
  public A removeFromIptables(io.fabric8.chaosmesh.v1alpha1.RawIptables... items) {
    for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").remove(builder);if (this.iptables != null) {this.iptables.remove(builder);}} return (A)this;
  }
  public A removeAllFromIptables(Collection<RawIptables> items) {
    for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").remove(builder);if (this.iptables != null) {this.iptables.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIptables(Predicate<RawIptablesBuilder> predicate) {
    if (iptables == null) return (A) this;
    final Iterator<RawIptablesBuilder> each = iptables.iterator();
    final List visitables = _visitables.get("iptables");
    while (each.hasNext()) {
      RawIptablesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildIptables instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RawIptables> getIptables() {
    return iptables != null ? build(iptables) : null;
  }
  public List<RawIptables> buildIptables() {
    return iptables != null ? build(iptables) : null;
  }
  public RawIptables buildIptable(Integer index) {
    return this.iptables.get(index).build();
  }
  public RawIptables buildFirstIptable() {
    return this.iptables.get(0).build();
  }
  public RawIptables buildLastIptable() {
    return this.iptables.get(iptables.size() - 1).build();
  }
  public RawIptables buildMatchingIptable(Predicate<RawIptablesBuilder> predicate) {
    for (RawIptablesBuilder item: iptables) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingIptable(Predicate<RawIptablesBuilder> predicate) {
    for (RawIptablesBuilder item: iptables) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIptables(List<RawIptables> iptables) {
    if (this.iptables != null) { _visitables.get("iptables").removeAll(this.iptables);}
    if (iptables != null) {this.iptables = new ArrayList(); for (RawIptables item : iptables){this.addToIptables(item);}} else { this.iptables = null;} return (A) this;
  }
  public A withIptables(io.fabric8.chaosmesh.v1alpha1.RawIptables... iptables) {
    if (this.iptables != null) {this.iptables.clear();}
    if (iptables != null) {for (RawIptables item :iptables){ this.addToIptables(item);}} return (A) this;
  }
  public Boolean hasIptables() {
    return iptables != null && !iptables.isEmpty();
  }
  public PodNetworkChaosSpecFluent.IptablesNested<A> addNewIptable() {
    return new PodNetworkChaosSpecFluentImpl.IptablesNestedImpl();
  }
  public PodNetworkChaosSpecFluent.IptablesNested<A> addNewIptableLike(RawIptables item) {
    return new PodNetworkChaosSpecFluentImpl.IptablesNestedImpl(-1, item);
  }
  public PodNetworkChaosSpecFluent.IptablesNested<A> setNewIptableLike(Integer index,RawIptables item) {
    return new PodNetworkChaosSpecFluentImpl.IptablesNestedImpl(index, item);
  }
  public PodNetworkChaosSpecFluent.IptablesNested<A> editIptable(Integer index) {
    if (iptables.size() <= index) throw new RuntimeException("Can't edit iptables. Index exceeds size.");
    return setNewIptableLike(index, buildIptable(index));
  }
  public PodNetworkChaosSpecFluent.IptablesNested<A> editFirstIptable() {
    if (iptables.size() == 0) throw new RuntimeException("Can't edit first iptables. The list is empty.");
    return setNewIptableLike(0, buildIptable(0));
  }
  public PodNetworkChaosSpecFluent.IptablesNested<A> editLastIptable() {
    int index = iptables.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last iptables. The list is empty.");
    return setNewIptableLike(index, buildIptable(index));
  }
  public PodNetworkChaosSpecFluent.IptablesNested<A> editMatchingIptable(Predicate<RawIptablesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<iptables.size();i++) { 
    if (predicate.test(iptables.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching iptables. No match found.");
    return setNewIptableLike(index, buildIptable(index));
  }
  public A addToTcs(Integer index,RawTrafficControl item) {
    if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
    RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").add(index >= 0 ? index : _visitables.get("tcs").size(), builder);this.tcs.add(index >= 0 ? index : tcs.size(), builder); return (A)this;
  }
  public A setToTcs(Integer index,RawTrafficControl item) {
    if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
    RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);
    if (index < 0 || index >= _visitables.get("tcs").size()) { _visitables.get("tcs").add(builder); } else { _visitables.get("tcs").set(index, builder);}
    if (index < 0 || index >= tcs.size()) { tcs.add(builder); } else { tcs.set(index, builder);}
     return (A)this;
  }
  public A addToTcs(io.fabric8.chaosmesh.v1alpha1.RawTrafficControl... items) {
    if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
    for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").add(builder);this.tcs.add(builder);} return (A)this;
  }
  public A addAllToTcs(Collection<RawTrafficControl> items) {
    if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
    for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").add(builder);this.tcs.add(builder);} return (A)this;
  }
  public A removeFromTcs(io.fabric8.chaosmesh.v1alpha1.RawTrafficControl... items) {
    for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").remove(builder);if (this.tcs != null) {this.tcs.remove(builder);}} return (A)this;
  }
  public A removeAllFromTcs(Collection<RawTrafficControl> items) {
    for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").remove(builder);if (this.tcs != null) {this.tcs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTcs(Predicate<RawTrafficControlBuilder> predicate) {
    if (tcs == null) return (A) this;
    final Iterator<RawTrafficControlBuilder> each = tcs.iterator();
    final List visitables = _visitables.get("tcs");
    while (each.hasNext()) {
      RawTrafficControlBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTcs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RawTrafficControl> getTcs() {
    return tcs != null ? build(tcs) : null;
  }
  public List<RawTrafficControl> buildTcs() {
    return tcs != null ? build(tcs) : null;
  }
  public RawTrafficControl buildTc(Integer index) {
    return this.tcs.get(index).build();
  }
  public RawTrafficControl buildFirstTc() {
    return this.tcs.get(0).build();
  }
  public RawTrafficControl buildLastTc() {
    return this.tcs.get(tcs.size() - 1).build();
  }
  public RawTrafficControl buildMatchingTc(Predicate<RawTrafficControlBuilder> predicate) {
    for (RawTrafficControlBuilder item: tcs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTc(Predicate<RawTrafficControlBuilder> predicate) {
    for (RawTrafficControlBuilder item: tcs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTcs(List<RawTrafficControl> tcs) {
    if (this.tcs != null) { _visitables.get("tcs").removeAll(this.tcs);}
    if (tcs != null) {this.tcs = new ArrayList(); for (RawTrafficControl item : tcs){this.addToTcs(item);}} else { this.tcs = null;} return (A) this;
  }
  public A withTcs(io.fabric8.chaosmesh.v1alpha1.RawTrafficControl... tcs) {
    if (this.tcs != null) {this.tcs.clear();}
    if (tcs != null) {for (RawTrafficControl item :tcs){ this.addToTcs(item);}} return (A) this;
  }
  public Boolean hasTcs() {
    return tcs != null && !tcs.isEmpty();
  }
  public PodNetworkChaosSpecFluent.TcsNested<A> addNewTc() {
    return new PodNetworkChaosSpecFluentImpl.TcsNestedImpl();
  }
  public PodNetworkChaosSpecFluent.TcsNested<A> addNewTcLike(RawTrafficControl item) {
    return new PodNetworkChaosSpecFluentImpl.TcsNestedImpl(-1, item);
  }
  public PodNetworkChaosSpecFluent.TcsNested<A> setNewTcLike(Integer index,RawTrafficControl item) {
    return new PodNetworkChaosSpecFluentImpl.TcsNestedImpl(index, item);
  }
  public PodNetworkChaosSpecFluent.TcsNested<A> editTc(Integer index) {
    if (tcs.size() <= index) throw new RuntimeException("Can't edit tcs. Index exceeds size.");
    return setNewTcLike(index, buildTc(index));
  }
  public PodNetworkChaosSpecFluent.TcsNested<A> editFirstTc() {
    if (tcs.size() == 0) throw new RuntimeException("Can't edit first tcs. The list is empty.");
    return setNewTcLike(0, buildTc(0));
  }
  public PodNetworkChaosSpecFluent.TcsNested<A> editLastTc() {
    int index = tcs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tcs. The list is empty.");
    return setNewTcLike(index, buildTc(index));
  }
  public PodNetworkChaosSpecFluent.TcsNested<A> editMatchingTc(Predicate<RawTrafficControlBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tcs.size();i++) { 
    if (predicate.test(tcs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tcs. No match found.");
    return setNewTcLike(index, buildTc(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodNetworkChaosSpecFluentImpl that = (PodNetworkChaosSpecFluentImpl) o;
    if (ipsets != null ? !ipsets.equals(that.ipsets) :that.ipsets != null) return false;
    if (iptables != null ? !iptables.equals(that.iptables) :that.iptables != null) return false;
    if (tcs != null ? !tcs.equals(that.tcs) :that.tcs != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ipsets,  iptables,  tcs,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ipsets != null && !ipsets.isEmpty()) { sb.append("ipsets:"); sb.append(ipsets + ","); }
    if (iptables != null && !iptables.isEmpty()) { sb.append("iptables:"); sb.append(iptables + ","); }
    if (tcs != null && !tcs.isEmpty()) { sb.append("tcs:"); sb.append(tcs); }
    sb.append("}");
    return sb.toString();
  }
  class IpsetsNestedImpl<N> extends RawIPSetFluentImpl<PodNetworkChaosSpecFluent.IpsetsNested<N>> implements PodNetworkChaosSpecFluent.IpsetsNested<N>,Nested<N>{
    IpsetsNestedImpl(Integer index,RawIPSet item) {
      this.index = index;
      this.builder = new RawIPSetBuilder(this, item);
    }
    IpsetsNestedImpl() {
      this.index = -1;
      this.builder = new RawIPSetBuilder(this);
    }
    RawIPSetBuilder builder;
    Integer index;
    public N and() {
      return (N) PodNetworkChaosSpecFluentImpl.this.setToIpsets(index,builder.build());
    }
    public N endIpset() {
      return and();
    }
    
  }
  class IptablesNestedImpl<N> extends RawIptablesFluentImpl<PodNetworkChaosSpecFluent.IptablesNested<N>> implements PodNetworkChaosSpecFluent.IptablesNested<N>,Nested<N>{
    IptablesNestedImpl(Integer index,RawIptables item) {
      this.index = index;
      this.builder = new RawIptablesBuilder(this, item);
    }
    IptablesNestedImpl() {
      this.index = -1;
      this.builder = new RawIptablesBuilder(this);
    }
    RawIptablesBuilder builder;
    Integer index;
    public N and() {
      return (N) PodNetworkChaosSpecFluentImpl.this.setToIptables(index,builder.build());
    }
    public N endIptable() {
      return and();
    }
    
  }
  class TcsNestedImpl<N> extends RawTrafficControlFluentImpl<PodNetworkChaosSpecFluent.TcsNested<N>> implements PodNetworkChaosSpecFluent.TcsNested<N>,Nested<N>{
    TcsNestedImpl(Integer index,RawTrafficControl item) {
      this.index = index;
      this.builder = new RawTrafficControlBuilder(this, item);
    }
    TcsNestedImpl() {
      this.index = -1;
      this.builder = new RawTrafficControlBuilder(this);
    }
    RawTrafficControlBuilder builder;
    Integer index;
    public N and() {
      return (N) PodNetworkChaosSpecFluentImpl.this.setToTcs(index,builder.build());
    }
    public N endTc() {
      return and();
    }
    
  }
  
}