package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KernelChaosBuilder extends KernelChaosFluentImpl<KernelChaosBuilder> implements VisitableBuilder<KernelChaos,KernelChaosBuilder>{
  public KernelChaosBuilder() {
    this(false);
  }
  public KernelChaosBuilder(Boolean validationEnabled) {
    this(new KernelChaos(), validationEnabled);
  }
  public KernelChaosBuilder(KernelChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public KernelChaosBuilder(KernelChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KernelChaos(), validationEnabled);
  }
  public KernelChaosBuilder(KernelChaosFluent<?> fluent,KernelChaos instance) {
    this(fluent, instance, false);
  }
  public KernelChaosBuilder(KernelChaosFluent<?> fluent,KernelChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public KernelChaosBuilder(KernelChaos instance) {
    this(instance,false);
  }
  public KernelChaosBuilder(KernelChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  KernelChaosFluent<?> fluent;
  Boolean validationEnabled;
  public KernelChaos build() {
    KernelChaos buildable = new KernelChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}