package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BlockChaosSpecFluentImpl<A extends BlockChaosSpecFluent<A>> extends BaseFluent<A> implements BlockChaosSpecFluent<A>{
  public BlockChaosSpecFluentImpl() {
  }
  public BlockChaosSpecFluentImpl(BlockChaosSpec instance) {
    this.withAction(instance.getAction()); 
    this.withContainerNames(instance.getContainerNames()); 
    this.withDelay(instance.getDelay()); 
    this.withDuration(instance.getDuration()); 
    this.withIops(instance.getIops()); 
    this.withMode(instance.getMode()); 
    this.withSelector(instance.getSelector()); 
    this.withValue(instance.getValue()); 
    this.withVolumeName(instance.getVolumeName()); 
  }
  private String action;
  private List<String> containerNames = new ArrayList<String>();
  private BlockDelaySpecBuilder delay;
  private String duration;
  private Integer iops;
  private String mode;
  private PodSelectorSpecBuilder selector;
  private String value;
  private String volumeName;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public A addToContainerNames(Integer index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.add(index, item);
    return (A)this;
  }
  public A setToContainerNames(Integer index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.set(index, item); return (A)this;
  }
  public A addToContainerNames(java.lang.String... items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A addAllToContainerNames(Collection<String> items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A removeFromContainerNames(java.lang.String... items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public A removeAllFromContainerNames(Collection<String> items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public List<String> getContainerNames() {
    return this.containerNames;
  }
  public String getContainerName(Integer index) {
    return this.containerNames.get(index);
  }
  public String getFirstContainerName() {
    return this.containerNames.get(0);
  }
  public String getLastContainerName() {
    return this.containerNames.get(containerNames.size() - 1);
  }
  public String getMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerNames(List<String> containerNames) {
    if (containerNames != null) {this.containerNames = new ArrayList(); for (String item : containerNames){this.addToContainerNames(item);}} else { this.containerNames = null;} return (A) this;
  }
  public A withContainerNames(java.lang.String... containerNames) {
    if (this.containerNames != null) {this.containerNames.clear();}
    if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
  }
  public Boolean hasContainerNames() {
    return containerNames != null && !containerNames.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildDelay instead.
   * @return The buildable object.
   */
  @Deprecated
  public BlockDelaySpec getDelay() {
    return this.delay!=null ?this.delay.build():null;
  }
  public BlockDelaySpec buildDelay() {
    return this.delay!=null ?this.delay.build():null;
  }
  public A withDelay(BlockDelaySpec delay) {
    _visitables.get("delay").remove(this.delay);
    if (delay!=null){ this.delay= new BlockDelaySpecBuilder(delay); _visitables.get("delay").add(this.delay);} else { this.delay = null; _visitables.get("delay").remove(this.delay); } return (A) this;
  }
  public Boolean hasDelay() {
    return this.delay != null;
  }
  public A withNewDelay(String correlation,String jitter,String latency) {
    return (A)withDelay(new BlockDelaySpec(correlation, jitter, latency));
  }
  public BlockChaosSpecFluent.DelayNested<A> withNewDelay() {
    return new BlockChaosSpecFluentImpl.DelayNestedImpl();
  }
  public BlockChaosSpecFluent.DelayNested<A> withNewDelayLike(BlockDelaySpec item) {
    return new BlockChaosSpecFluentImpl.DelayNestedImpl(item);
  }
  public BlockChaosSpecFluent.DelayNested<A> editDelay() {
    return withNewDelayLike(getDelay());
  }
  public BlockChaosSpecFluent.DelayNested<A> editOrNewDelay() {
    return withNewDelayLike(getDelay() != null ? getDelay(): new BlockDelaySpecBuilder().build());
  }
  public BlockChaosSpecFluent.DelayNested<A> editOrNewDelayLike(BlockDelaySpec item) {
    return withNewDelayLike(getDelay() != null ? getDelay(): item);
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public Integer getIops() {
    return this.iops;
  }
  public A withIops(Integer iops) {
    this.iops=iops; return (A) this;
  }
  public Boolean hasIops() {
    return this.iops != null;
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public PodSelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(PodSelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new PodSelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public BlockChaosSpecFluent.SelectorNested<A> withNewSelector() {
    return new BlockChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public BlockChaosSpecFluent.SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
    return new BlockChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public BlockChaosSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public BlockChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new PodSelectorSpecBuilder().build());
  }
  public BlockChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public String getVolumeName() {
    return this.volumeName;
  }
  public A withVolumeName(String volumeName) {
    this.volumeName=volumeName; return (A) this;
  }
  public Boolean hasVolumeName() {
    return this.volumeName != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BlockChaosSpecFluentImpl that = (BlockChaosSpecFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (containerNames != null ? !containerNames.equals(that.containerNames) :that.containerNames != null) return false;
    if (delay != null ? !delay.equals(that.delay) :that.delay != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (iops != null ? !iops.equals(that.iops) :that.iops != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    if (volumeName != null ? !volumeName.equals(that.volumeName) :that.volumeName != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  containerNames,  delay,  duration,  iops,  mode,  selector,  value,  volumeName,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (containerNames != null && !containerNames.isEmpty()) { sb.append("containerNames:"); sb.append(containerNames + ","); }
    if (delay != null) { sb.append("delay:"); sb.append(delay + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (iops != null) { sb.append("iops:"); sb.append(iops + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName); }
    sb.append("}");
    return sb.toString();
  }
  class DelayNestedImpl<N> extends BlockDelaySpecFluentImpl<BlockChaosSpecFluent.DelayNested<N>> implements BlockChaosSpecFluent.DelayNested<N>,Nested<N>{
    DelayNestedImpl(BlockDelaySpec item) {
      this.builder = new BlockDelaySpecBuilder(this, item);
    }
    DelayNestedImpl() {
      this.builder = new BlockDelaySpecBuilder(this);
    }
    BlockDelaySpecBuilder builder;
    public N and() {
      return (N) BlockChaosSpecFluentImpl.this.withDelay(builder.build());
    }
    public N endDelay() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends PodSelectorSpecFluentImpl<BlockChaosSpecFluent.SelectorNested<N>> implements BlockChaosSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(PodSelectorSpec item) {
      this.builder = new PodSelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new PodSelectorSpecBuilder(this);
    }
    PodSelectorSpecBuilder builder;
    public N and() {
      return (N) BlockChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}