package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AttrOverrideSpecBuilder extends AttrOverrideSpecFluentImpl<AttrOverrideSpecBuilder> implements VisitableBuilder<AttrOverrideSpec,AttrOverrideSpecBuilder>{
  public AttrOverrideSpecBuilder() {
    this(false);
  }
  public AttrOverrideSpecBuilder(Boolean validationEnabled) {
    this(new AttrOverrideSpec(), validationEnabled);
  }
  public AttrOverrideSpecBuilder(AttrOverrideSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AttrOverrideSpecBuilder(AttrOverrideSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AttrOverrideSpec(), validationEnabled);
  }
  public AttrOverrideSpecBuilder(AttrOverrideSpecFluent<?> fluent,AttrOverrideSpec instance) {
    this(fluent, instance, false);
  }
  public AttrOverrideSpecBuilder(AttrOverrideSpecFluent<?> fluent,AttrOverrideSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAtime(instance.getAtime()); 
    fluent.withBlocks(instance.getBlocks()); 
    fluent.withCtime(instance.getCtime()); 
    fluent.withGid(instance.getGid()); 
    fluent.withIno(instance.getIno()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMtime(instance.getMtime()); 
    fluent.withNlink(instance.getNlink()); 
    fluent.withPerm(instance.getPerm()); 
    fluent.withRdev(instance.getRdev()); 
    fluent.withSize(instance.getSize()); 
    fluent.withUid(instance.getUid()); 
    this.validationEnabled = validationEnabled; 
  }
  public AttrOverrideSpecBuilder(AttrOverrideSpec instance) {
    this(instance,false);
  }
  public AttrOverrideSpecBuilder(AttrOverrideSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAtime(instance.getAtime()); 
    this.withBlocks(instance.getBlocks()); 
    this.withCtime(instance.getCtime()); 
    this.withGid(instance.getGid()); 
    this.withIno(instance.getIno()); 
    this.withKind(instance.getKind()); 
    this.withMtime(instance.getMtime()); 
    this.withNlink(instance.getNlink()); 
    this.withPerm(instance.getPerm()); 
    this.withRdev(instance.getRdev()); 
    this.withSize(instance.getSize()); 
    this.withUid(instance.getUid()); 
    this.validationEnabled = validationEnabled; 
  }
  AttrOverrideSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AttrOverrideSpec build() {
    AttrOverrideSpec buildable = new AttrOverrideSpec(fluent.getAtime(),fluent.getBlocks(),fluent.getCtime(),fluent.getGid(),fluent.getIno(),fluent.getKind(),fluent.getMtime(),fluent.getNlink(),fluent.getPerm(),fluent.getRdev(),fluent.getSize(),fluent.getUid());
    return buildable;
  }
  
}