package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StressChaosBuilder extends StressChaosFluentImpl<StressChaosBuilder> implements VisitableBuilder<StressChaos,StressChaosBuilder>{
  public StressChaosBuilder() {
    this(false);
  }
  public StressChaosBuilder(Boolean validationEnabled) {
    this(new StressChaos(), validationEnabled);
  }
  public StressChaosBuilder(StressChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public StressChaosBuilder(StressChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StressChaos(), validationEnabled);
  }
  public StressChaosBuilder(StressChaosFluent<?> fluent,StressChaos instance) {
    this(fluent, instance, false);
  }
  public StressChaosBuilder(StressChaosFluent<?> fluent,StressChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public StressChaosBuilder(StressChaos instance) {
    this(instance,false);
  }
  public StressChaosBuilder(StressChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  StressChaosFluent<?> fluent;
  Boolean validationEnabled;
  public StressChaos build() {
    StressChaos buildable = new StressChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}