package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Long;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodIOChaosFluentImpl<A extends PodIOChaosFluent<A>> extends BaseFluent<A> implements PodIOChaosFluent<A>{
  public PodIOChaosFluentImpl() {
  }
  public PodIOChaosFluentImpl(PodIOChaos instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private PodIOChaosSpecBuilder spec;
  private PodIOChaosStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public PodIOChaosFluent.MetadataNested<A> withNewMetadata() {
    return new PodIOChaosFluentImpl.MetadataNestedImpl();
  }
  public PodIOChaosFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new PodIOChaosFluentImpl.MetadataNestedImpl(item);
  }
  public PodIOChaosFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public PodIOChaosFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public PodIOChaosFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodIOChaosSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public PodIOChaosSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(PodIOChaosSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new PodIOChaosSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public PodIOChaosFluent.SpecNested<A> withNewSpec() {
    return new PodIOChaosFluentImpl.SpecNestedImpl();
  }
  public PodIOChaosFluent.SpecNested<A> withNewSpecLike(PodIOChaosSpec item) {
    return new PodIOChaosFluentImpl.SpecNestedImpl(item);
  }
  public PodIOChaosFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public PodIOChaosFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new PodIOChaosSpecBuilder().build());
  }
  public PodIOChaosFluent.SpecNested<A> editOrNewSpecLike(PodIOChaosSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodIOChaosStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public PodIOChaosStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(PodIOChaosStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new PodIOChaosStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public A withNewStatus(String failedMessage,Long observedGeneration,Long pid,Long startTime) {
    return (A)withStatus(new PodIOChaosStatus(failedMessage, observedGeneration, pid, startTime));
  }
  public PodIOChaosFluent.StatusNested<A> withNewStatus() {
    return new PodIOChaosFluentImpl.StatusNestedImpl();
  }
  public PodIOChaosFluent.StatusNested<A> withNewStatusLike(PodIOChaosStatus item) {
    return new PodIOChaosFluentImpl.StatusNestedImpl(item);
  }
  public PodIOChaosFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public PodIOChaosFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new PodIOChaosStatusBuilder().build());
  }
  public PodIOChaosFluent.StatusNested<A> editOrNewStatusLike(PodIOChaosStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodIOChaosFluentImpl that = (PodIOChaosFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PodIOChaosFluent.MetadataNested<N>> implements PodIOChaosFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) PodIOChaosFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends PodIOChaosSpecFluentImpl<PodIOChaosFluent.SpecNested<N>> implements PodIOChaosFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(PodIOChaosSpec item) {
      this.builder = new PodIOChaosSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new PodIOChaosSpecBuilder(this);
    }
    PodIOChaosSpecBuilder builder;
    public N and() {
      return (N) PodIOChaosFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends PodIOChaosStatusFluentImpl<PodIOChaosFluent.StatusNested<N>> implements PodIOChaosFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(PodIOChaosStatus item) {
      this.builder = new PodIOChaosStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new PodIOChaosStatusBuilder(this);
    }
    PodIOChaosStatusBuilder builder;
    public N and() {
      return (N) PodIOChaosFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}