package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodHttpChaosPatchActionsBuilder extends PodHttpChaosPatchActionsFluentImpl<PodHttpChaosPatchActionsBuilder> implements VisitableBuilder<PodHttpChaosPatchActions,PodHttpChaosPatchActionsBuilder>{
  public PodHttpChaosPatchActionsBuilder() {
    this(false);
  }
  public PodHttpChaosPatchActionsBuilder(Boolean validationEnabled) {
    this(new PodHttpChaosPatchActions(), validationEnabled);
  }
  public PodHttpChaosPatchActionsBuilder(PodHttpChaosPatchActionsFluent<?> fluent) {
    this(fluent, false);
  }
  public PodHttpChaosPatchActionsBuilder(PodHttpChaosPatchActionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodHttpChaosPatchActions(), validationEnabled);
  }
  public PodHttpChaosPatchActionsBuilder(PodHttpChaosPatchActionsFluent<?> fluent,PodHttpChaosPatchActions instance) {
    this(fluent, instance, false);
  }
  public PodHttpChaosPatchActionsBuilder(PodHttpChaosPatchActionsFluent<?> fluent,PodHttpChaosPatchActions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBody(instance.getBody()); 
    fluent.withHeaders(instance.getHeaders()); 
    fluent.withQueries(instance.getQueries()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodHttpChaosPatchActionsBuilder(PodHttpChaosPatchActions instance) {
    this(instance,false);
  }
  public PodHttpChaosPatchActionsBuilder(PodHttpChaosPatchActions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBody(instance.getBody()); 
    this.withHeaders(instance.getHeaders()); 
    this.withQueries(instance.getQueries()); 
    this.validationEnabled = validationEnabled; 
  }
  PodHttpChaosPatchActionsFluent<?> fluent;
  Boolean validationEnabled;
  public PodHttpChaosPatchActions build() {
    PodHttpChaosPatchActions buildable = new PodHttpChaosPatchActions(fluent.getBody(),fluent.getHeaders(),fluent.getQueries());
    return buildable;
  }
  
}