package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkDNSSpecBuilder extends NetworkDNSSpecFluentImpl<NetworkDNSSpecBuilder> implements VisitableBuilder<NetworkDNSSpec,NetworkDNSSpecBuilder>{
  public NetworkDNSSpecBuilder() {
    this(false);
  }
  public NetworkDNSSpecBuilder(Boolean validationEnabled) {
    this(new NetworkDNSSpec(), validationEnabled);
  }
  public NetworkDNSSpecBuilder(NetworkDNSSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkDNSSpecBuilder(NetworkDNSSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkDNSSpec(), validationEnabled);
  }
  public NetworkDNSSpecBuilder(NetworkDNSSpecFluent<?> fluent,NetworkDNSSpec instance) {
    this(fluent, instance, false);
  }
  public NetworkDNSSpecBuilder(NetworkDNSSpecFluent<?> fluent,NetworkDNSSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDnsDomainName(instance.getDnsDomainName()); 
    fluent.withDnsIp(instance.getDnsIp()); 
    fluent.withDnsServer(instance.getDnsServer()); 
    this.validationEnabled = validationEnabled; 
  }
  public NetworkDNSSpecBuilder(NetworkDNSSpec instance) {
    this(instance,false);
  }
  public NetworkDNSSpecBuilder(NetworkDNSSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDnsDomainName(instance.getDnsDomainName()); 
    this.withDnsIp(instance.getDnsIp()); 
    this.withDnsServer(instance.getDnsServer()); 
    this.validationEnabled = validationEnabled; 
  }
  NetworkDNSSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkDNSSpec build() {
    NetworkDNSSpec buildable = new NetworkDNSSpec(fluent.getDnsDomainName(),fluent.getDnsIp(),fluent.getDnsServer());
    return buildable;
  }
  
}