package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JVMStressSpecBuilder extends JVMStressSpecFluentImpl<JVMStressSpecBuilder> implements VisitableBuilder<JVMStressSpec,JVMStressSpecBuilder>{
  public JVMStressSpecBuilder() {
    this(false);
  }
  public JVMStressSpecBuilder(Boolean validationEnabled) {
    this(new JVMStressSpec(), validationEnabled);
  }
  public JVMStressSpecBuilder(JVMStressSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JVMStressSpecBuilder(JVMStressSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JVMStressSpec(), validationEnabled);
  }
  public JVMStressSpecBuilder(JVMStressSpecFluent<?> fluent,JVMStressSpec instance) {
    this(fluent, instance, false);
  }
  public JVMStressSpecBuilder(JVMStressSpecFluent<?> fluent,JVMStressSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCpuCount(instance.getCpuCount()); 
    fluent.withMemType(instance.getMemType()); 
    fluent.withPid(instance.getPid()); 
    fluent.withPort(instance.getPort()); 
    this.validationEnabled = validationEnabled; 
  }
  public JVMStressSpecBuilder(JVMStressSpec instance) {
    this(instance,false);
  }
  public JVMStressSpecBuilder(JVMStressSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCpuCount(instance.getCpuCount()); 
    this.withMemType(instance.getMemType()); 
    this.withPid(instance.getPid()); 
    this.withPort(instance.getPort()); 
    this.validationEnabled = validationEnabled; 
  }
  JVMStressSpecFluent<?> fluent;
  Boolean validationEnabled;
  public JVMStressSpec build() {
    JVMStressSpec buildable = new JVMStressSpec(fluent.getCpuCount(),fluent.getMemType(),fluent.getPid(),fluent.getPort());
    return buildable;
  }
  
}