package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JVMGCSpecBuilder extends JVMGCSpecFluentImpl<JVMGCSpecBuilder> implements VisitableBuilder<JVMGCSpec,JVMGCSpecBuilder>{
  public JVMGCSpecBuilder() {
    this(false);
  }
  public JVMGCSpecBuilder(Boolean validationEnabled) {
    this(new JVMGCSpec(), validationEnabled);
  }
  public JVMGCSpecBuilder(JVMGCSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JVMGCSpecBuilder(JVMGCSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JVMGCSpec(), validationEnabled);
  }
  public JVMGCSpecBuilder(JVMGCSpecFluent<?> fluent,JVMGCSpec instance) {
    this(fluent, instance, false);
  }
  public JVMGCSpecBuilder(JVMGCSpecFluent<?> fluent,JVMGCSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPid(instance.getPid()); 
    fluent.withPort(instance.getPort()); 
    this.validationEnabled = validationEnabled; 
  }
  public JVMGCSpecBuilder(JVMGCSpec instance) {
    this(instance,false);
  }
  public JVMGCSpecBuilder(JVMGCSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withPid(instance.getPid()); 
    this.withPort(instance.getPort()); 
    this.validationEnabled = validationEnabled; 
  }
  JVMGCSpecFluent<?> fluent;
  Boolean validationEnabled;
  public JVMGCSpec build() {
    JVMGCSpec buildable = new JVMGCSpec(fluent.getPid(),fluent.getPort());
    return buildable;
  }
  
}