package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JVMChaosSpecFluentImpl<A extends JVMChaosSpecFluent<A>> extends BaseFluent<A> implements JVMChaosSpecFluent<A>{
  public JVMChaosSpecFluentImpl() {
  }
  public JVMChaosSpecFluentImpl(JVMChaosSpec instance) {
    this.withAction(instance.getAction()); 
    this.withClassName(instance.getClassName()); 
    this.withContainerNames(instance.getContainerNames()); 
    this.withCpuCount(instance.getCpuCount()); 
    this.withDuration(instance.getDuration()); 
    this.withException(instance.getException()); 
    this.withLatency(instance.getLatency()); 
    this.withMemType(instance.getMemType()); 
    this.withMethod(instance.getMethod()); 
    this.withMode(instance.getMode()); 
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withRuleData(instance.getRuleData()); 
    this.withSelector(instance.getSelector()); 
    this.withValue(instance.getValue()); 
  }
  private String action;
  private String className;
  private List<String> containerNames = new ArrayList<String>();
  private Integer cpuCount;
  private String duration;
  private String exception;
  private Integer latency;
  private String memType;
  private String method;
  private String mode;
  private String name;
  private Integer port;
  private String ruleData;
  private PodSelectorSpecBuilder selector;
  private String value;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public String getClassName() {
    return this.className;
  }
  public A withClassName(String className) {
    this.className=className; return (A) this;
  }
  public Boolean hasClassName() {
    return this.className != null;
  }
  public A addToContainerNames(Integer index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.add(index, item);
    return (A)this;
  }
  public A setToContainerNames(Integer index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.set(index, item); return (A)this;
  }
  public A addToContainerNames(java.lang.String... items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A addAllToContainerNames(Collection<String> items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A removeFromContainerNames(java.lang.String... items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public A removeAllFromContainerNames(Collection<String> items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public List<String> getContainerNames() {
    return this.containerNames;
  }
  public String getContainerName(Integer index) {
    return this.containerNames.get(index);
  }
  public String getFirstContainerName() {
    return this.containerNames.get(0);
  }
  public String getLastContainerName() {
    return this.containerNames.get(containerNames.size() - 1);
  }
  public String getMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerNames(List<String> containerNames) {
    if (containerNames != null) {this.containerNames = new ArrayList(); for (String item : containerNames){this.addToContainerNames(item);}} else { this.containerNames = null;} return (A) this;
  }
  public A withContainerNames(java.lang.String... containerNames) {
    if (this.containerNames != null) {this.containerNames.clear();}
    if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
  }
  public Boolean hasContainerNames() {
    return containerNames != null && !containerNames.isEmpty();
  }
  public Integer getCpuCount() {
    return this.cpuCount;
  }
  public A withCpuCount(Integer cpuCount) {
    this.cpuCount=cpuCount; return (A) this;
  }
  public Boolean hasCpuCount() {
    return this.cpuCount != null;
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public String getException() {
    return this.exception;
  }
  public A withException(String exception) {
    this.exception=exception; return (A) this;
  }
  public Boolean hasException() {
    return this.exception != null;
  }
  public Integer getLatency() {
    return this.latency;
  }
  public A withLatency(Integer latency) {
    this.latency=latency; return (A) this;
  }
  public Boolean hasLatency() {
    return this.latency != null;
  }
  public String getMemType() {
    return this.memType;
  }
  public A withMemType(String memType) {
    this.memType=memType; return (A) this;
  }
  public Boolean hasMemType() {
    return this.memType != null;
  }
  public String getMethod() {
    return this.method;
  }
  public A withMethod(String method) {
    this.method=method; return (A) this;
  }
  public Boolean hasMethod() {
    return this.method != null;
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public Integer getPort() {
    return this.port;
  }
  public A withPort(Integer port) {
    this.port=port; return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public String getRuleData() {
    return this.ruleData;
  }
  public A withRuleData(String ruleData) {
    this.ruleData=ruleData; return (A) this;
  }
  public Boolean hasRuleData() {
    return this.ruleData != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public PodSelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(PodSelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new PodSelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public JVMChaosSpecFluent.SelectorNested<A> withNewSelector() {
    return new JVMChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public JVMChaosSpecFluent.SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
    return new JVMChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public JVMChaosSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public JVMChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new PodSelectorSpecBuilder().build());
  }
  public JVMChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JVMChaosSpecFluentImpl that = (JVMChaosSpecFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (className != null ? !className.equals(that.className) :that.className != null) return false;
    if (containerNames != null ? !containerNames.equals(that.containerNames) :that.containerNames != null) return false;
    if (cpuCount != null ? !cpuCount.equals(that.cpuCount) :that.cpuCount != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (exception != null ? !exception.equals(that.exception) :that.exception != null) return false;
    if (latency != null ? !latency.equals(that.latency) :that.latency != null) return false;
    if (memType != null ? !memType.equals(that.memType) :that.memType != null) return false;
    if (method != null ? !method.equals(that.method) :that.method != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (ruleData != null ? !ruleData.equals(that.ruleData) :that.ruleData != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  className,  containerNames,  cpuCount,  duration,  exception,  latency,  memType,  method,  mode,  name,  port,  ruleData,  selector,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (className != null) { sb.append("className:"); sb.append(className + ","); }
    if (containerNames != null && !containerNames.isEmpty()) { sb.append("containerNames:"); sb.append(containerNames + ","); }
    if (cpuCount != null) { sb.append("cpuCount:"); sb.append(cpuCount + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (exception != null) { sb.append("exception:"); sb.append(exception + ","); }
    if (latency != null) { sb.append("latency:"); sb.append(latency + ","); }
    if (memType != null) { sb.append("memType:"); sb.append(memType + ","); }
    if (method != null) { sb.append("method:"); sb.append(method + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (ruleData != null) { sb.append("ruleData:"); sb.append(ruleData + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  class SelectorNestedImpl<N> extends PodSelectorSpecFluentImpl<JVMChaosSpecFluent.SelectorNested<N>> implements JVMChaosSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(PodSelectorSpec item) {
      this.builder = new PodSelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new PodSelectorSpecBuilder(this);
    }
    PodSelectorSpecBuilder builder;
    public N and() {
      return (N) JVMChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}