package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JVMChaosListBuilder extends JVMChaosListFluentImpl<JVMChaosListBuilder> implements VisitableBuilder<JVMChaosList,JVMChaosListBuilder>{
  public JVMChaosListBuilder() {
    this(false);
  }
  public JVMChaosListBuilder(Boolean validationEnabled) {
    this(new JVMChaosList(), validationEnabled);
  }
  public JVMChaosListBuilder(JVMChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public JVMChaosListBuilder(JVMChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JVMChaosList(), validationEnabled);
  }
  public JVMChaosListBuilder(JVMChaosListFluent<?> fluent,JVMChaosList instance) {
    this(fluent, instance, false);
  }
  public JVMChaosListBuilder(JVMChaosListFluent<?> fluent,JVMChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public JVMChaosListBuilder(JVMChaosList instance) {
    this(instance,false);
  }
  public JVMChaosListBuilder(JVMChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  JVMChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public JVMChaosList build() {
    JVMChaosList buildable = new JVMChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}